/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.databinding.model;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.eclipse.wb.internal.core.databinding.model.IObserveInfo;
import org.eclipse.wb.internal.core.databinding.model.IObservePresentation;
import org.eclipse.wb.internal.core.databinding.model.presentation.IObservePresentationDecorator;
import org.eclipse.wb.internal.core.databinding.model.reference.IReferenceProvider;
import org.eclipse.wb.internal.core.databinding.ui.editor.IUiContentProvider;
import org.eclipse.wb.internal.swing.databinding.model.ObserveCreationType;
import org.eclipse.wb.internal.swing.databinding.model.bindings.BindingInfo;
import org.eclipse.wb.internal.swing.databinding.model.generic.IGenericType;
import org.eclipse.wb.internal.swing.databinding.model.properties.PropertyInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ObserveInfo
implements IObserveInfo {
    private IGenericType m_objectType;
    private final IReferenceProvider m_referenceProvider;
    private int m_bindingDecorationCorner;
    private List<BindingInfo> m_bindings;

    public ObserveInfo(IGenericType objectType, IReferenceProvider referenceProvider) {
        this.m_objectType = objectType;
        this.m_referenceProvider = referenceProvider;
    }

    public abstract ObserveCreationType getCreationType();

    public final IGenericType getObjectType() {
        return this.m_objectType;
    }

    protected final void setObjectType(IGenericType objectType) {
        this.m_objectType = objectType;
    }

    public final Class<?> getObjectClass() {
        return this.m_objectType.getRawType();
    }

    public final IReferenceProvider getReferenceProvider() {
        return this.m_referenceProvider;
    }

    public final String getReference() throws Exception {
        return this.m_referenceProvider.getReference();
    }

    public boolean isRepresentedBy(String reference) throws Exception {
        return reference.equals(this.m_referenceProvider.getReference());
    }

    public boolean canShared() {
        return false;
    }

    public PropertyInfo createProperty(ObserveInfo observeObject) throws Exception {
        throw new UnsupportedOperationException();
    }

    public void createBinding(BindingInfo binding) throws Exception {
        if (this.m_bindings == null) {
            this.m_bindings = Lists.newArrayList();
        }
        this.m_bindings.add(binding);
        this.updateBindingDecoration();
    }

    public void deleteBinding(BindingInfo binding) throws Exception {
        this.m_bindings.remove((Object)binding);
        if (this.m_bindings.isEmpty()) {
            this.m_bindings = null;
        }
        this.updateBindingDecoration();
    }

    public List<BindingInfo> getBindings() {
        if (this.m_bindings == null) {
            return Collections.emptyList();
        }
        return this.m_bindings;
    }

    protected final void setBindingDecoration(int decorationCorner) {
        this.m_bindingDecorationCorner = decorationCorner;
    }

    private void updateBindingDecoration() throws Exception {
        IObservePresentation presentation;
        if (this.m_bindingDecorationCorner != 0 && (presentation = this.getPresentation()) instanceof IObservePresentationDecorator) {
            IObservePresentationDecorator presentationDecorator = (IObservePresentationDecorator)presentation;
            presentationDecorator.setBindingDecorator(CollectionUtils.isEmpty(this.m_bindings) ? 0 : this.m_bindingDecorationCorner);
        }
    }

    public void createContentProviders(List<IUiContentProvider> providers, ObserveInfo observeObject, PropertyInfo observeAstProperty) throws Exception {
    }
}

