"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const typescript_1 = __importDefault(require("typescript"));
const ast_converter_1 = require("./ast-converter");
const eslint_1 = require("eslint");
const visitor_keys_1 = require("@typescript-eslint/parser/dist/visitor-keys");
function createProgram() {
    return typescript_1.default.createProgram({
        rootNames: [],
        options: {},
    });
}
describe("AstConverter", () => {
    describe("#convertToESLintSourceCode", () => {
        it("should create ESLint SourceCode insntance from TypeScript sourcefile", () => {
            const astConverter = new ast_converter_1.AstConverter({ getProgram: () => createProgram() });
            const sourceFile = typescript_1.default.createSourceFile("test.ts", "const a = 1", typescript_1.default.ScriptTarget.ESNext, true, typescript_1.default.ScriptKind.TS);
            const actual = astConverter.convertToESLintSourceCode(sourceFile, {});
            expect(actual).toBeInstanceOf(eslint_1.SourceCode);
            expect(actual.visitorKeys).toEqual(visitor_keys_1.visitorKeys);
        });
    });
});
//# sourceMappingURL=ast-converter.test.js.map