/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.parser.wsil;

import java.io.UnsupportedEncodingException;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class HTMLHeadHandler
extends DefaultHandler {
    private final char START_TAG = (char)60;
    private final char END_TAG = (char)62;
    private final String HEAD_START_TAG = "<head>";
    private final String HEAD_END_TAG = "</head>";
    private final String ROOT_START_TAG = "<root>";
    private final String ROOT_END_TAG = "</root>";
    private final String UTF8 = "UTF-8";
    private final String HTML_CONTENT = "content";
    private final String HTTP_EQUIV = "http-equiv";
    private final String HTTP_EQUIV_CONTENT_TYPE = "Content-Type";
    private final String CHARSET = "charset";
    private final String META = "meta";
    private final String NAME = "name";
    private final String SERVICE_INSPECTION = "serviceInspection";
    private final String CONTENT = "content";
    private final String LINK = "link";
    private final String TYPE = "type";
    private final String TEXT_XML = "text/xml";
    private final String REL = "rel";
    private final String ALTERNATE = "alternate";
    private final String HREF = "href";
    private String baseURI_;
    private Vector wsils_;
    private Vector discos_;
    private String byteEncoding = "UTF-8";

    public HTMLHeadHandler(String baseURI) {
        this.baseURI_ = baseURI;
        this.wsils_ = new Vector();
        this.discos_ = new Vector();
    }

    public String[] getWsils() {
        Object[] wsils = new String[this.wsils_.size()];
        this.wsils_.copyInto(wsils);
        return wsils;
    }

    public String[] getDiscos() {
        Object[] discos = new String[this.discos_.size()];
        this.discos_.copyInto(discos);
        return discos;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        String qNameLC = qName.toLowerCase();
        if (qNameLC.equals("meta")) {
            String nameValue = attributes.getValue("name");
            if ("serviceInspection".equals(nameValue)) {
                String wsilURI = attributes.getValue("content");
                if (this.baseURI_ != null && wsilURI.indexOf(":/") == -1) {
                    StringBuffer sb = new StringBuffer();
                    sb.append(this.baseURI_.substring(0, this.baseURI_.lastIndexOf("/") + 1));
                    sb.append(wsilURI);
                    wsilURI = sb.toString();
                }
                if (!this.wsils_.contains(wsilURI)) {
                    this.wsils_.add(wsilURI);
                }
            }
        } else if (qNameLC.equals("link")) {
            String type = attributes.getValue("type");
            String rel = attributes.getValue("rel");
            String href = attributes.getValue("href");
            if ("text/xml".equals(type) && "alternate".equals(rel) && href != null) {
                String discoURI = href;
                if (discoURI.indexOf(":/") == -1) {
                    StringBuffer sb = new StringBuffer();
                    sb.append(this.baseURI_.substring(0, this.baseURI_.lastIndexOf("/") + 1));
                    sb.append(discoURI);
                    discoURI = sb.toString();
                }
                if (!this.discos_.contains(discoURI)) {
                    this.discos_.add(discoURI);
                }
            }
        }
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
    }

    private boolean harvestTags(StringBuffer target, String document, String tag, String encoding) {
        boolean changeEncoding = false;
        int index = document.indexOf(60);
        int documentLength = document.length();
        int tagLength = tag.length();
        while (index != -1 && index + 1 + tagLength < documentLength) {
            String str = document.substring(index + 1, index + 1 + tagLength);
            if (str.toLowerCase().equals(tag)) {
                str = document.substring(index, document.indexOf(62, index + 1) + 1);
                target.append(str);
                index += str.length();
                if (tag.equals("meta")) {
                    int idxOfCharSet;
                    int idxOfEquals;
                    int idxOfClosingQuote;
                    int idxOfOpenQuote;
                    String contentValue;
                    String detectedEncodingValueUntrimmed;
                    String detectedEncodingValue;
                    int idxOfHTTPEQUIVClosingQuote;
                    int idxOfHTTPEQUIVOpenQuote;
                    String hTTPEQUIVValueUntrimmed;
                    int idxOfContent = str.indexOf("content");
                    int idxOfHTTPEQUIV = str.indexOf("http-equiv");
                    if (idxOfHTTPEQUIV != -1 && idxOfContent != -1 && (hTTPEQUIVValueUntrimmed = str.substring((idxOfHTTPEQUIVOpenQuote = str.indexOf("\"", idxOfHTTPEQUIV + 1)) + 1, idxOfHTTPEQUIVClosingQuote = str.indexOf("\"", idxOfHTTPEQUIVOpenQuote + 1))).trim().equals("Content-Type") && !(detectedEncodingValue = (detectedEncodingValueUntrimmed = (contentValue = str.substring((idxOfOpenQuote = str.indexOf("\"", idxOfContent + 1)) + 1, idxOfClosingQuote = str.indexOf("\"", idxOfOpenQuote + 1))).substring((idxOfEquals = contentValue.indexOf("=", (idxOfCharSet = contentValue.indexOf("charset")) + "charset".length())) + 1)).trim()).equals(encoding)) {
                        this.byteEncoding = detectedEncodingValue;
                        changeEncoding = true;
                        break;
                    }
                }
            } else {
                ++index;
            }
            index = document.indexOf(60, index);
        }
        return changeEncoding;
    }

    public byte[] harvestHeadTags(byte[] b) {
        String s;
        try {
            s = new String(b, this.byteEncoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            s = new String(b);
        }
        String head = s.toLowerCase();
        int headStartIndex = head.indexOf("<head>");
        int headEndIndex = head.indexOf("</head>");
        StringBuffer sb = new StringBuffer();
        sb.append("<root>");
        if (headStartIndex != -1 && headEndIndex != -1) {
            head = s.substring(headStartIndex, headEndIndex + "</head>".length());
            boolean encodingChanged = this.harvestTags(sb, head, "meta", this.byteEncoding);
            if (encodingChanged) {
                String s2;
                try {
                    s2 = new String(b, this.byteEncoding);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    s2 = new String(b);
                }
                String head2 = s2.toLowerCase();
                int head2StartIndex = head2.indexOf("<head>");
                int head2EndIndex = head2.indexOf("</head>");
                sb = new StringBuffer();
                sb.append("<root>");
                if (head2StartIndex != -1 && head2EndIndex != -1) {
                    head2 = s2.substring(head2StartIndex, head2EndIndex + "</head>".length());
                    this.harvestTags(sb, head2, "meta", this.byteEncoding);
                    this.harvestTags(sb, head2, "link", this.byteEncoding);
                }
            } else {
                this.harvestTags(sb, head, "link", this.byteEncoding);
            }
        }
        sb.append("</root>");
        try {
            return sb.toString().getBytes(this.byteEncoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return sb.toString().getBytes();
        }
    }

    public String getByteEncoding() {
        return this.byteEncoding;
    }
}

