/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.validator.rules;

import java.util.List;
import org.eclipse.bpel.validator.model.ARule;
import org.eclipse.bpel.validator.model.Filters;
import org.eclipse.bpel.validator.model.IFilter;
import org.eclipse.bpel.validator.model.INode;
import org.eclipse.bpel.validator.model.IProblem;
import org.eclipse.bpel.validator.model.NodeNameFilter;
import org.eclipse.bpel.validator.rules.CActivityValidator;

public class PickValidator
extends CActivityValidator {
    protected String fCreateInstance;
    protected int fOnMessages = 0;
    protected int fOnAlarms = 0;
    static IFilter<INode> CHILDREN = new NodeNameFilter(ND_ON_ALARM, ND_ON_MESSAGE);

    @Override
    public void checkChildren() {
        super.checkChildren();
        this.fOnMessages = this.checkChild(ND_ON_MESSAGE, 1, Integer.MAX_VALUE);
        this.fOnAlarms = this.checkChild(ND_ON_ALARM, 0, Integer.MAX_VALUE);
    }

    @ARule(sa=0, desc="Checks to see if the createInstance attribute is set.", author="michal.chmielewski@oracle.com", date="01/10/2007", errors="BPELC__UNSET_ATTRIBUTE,BPELC__INVALID_ATTRIBUTE_VALUE")
    public void rule_CheckCreateInstanceSet_1() {
        this.fCreateInstance = this.getAttribute(this.mNode, AT_CREATE_INSTANCE, 1, Filters.BOOLEAN_FILTER, false);
        if (PickValidator.isEmpty(this.fCreateInstance)) {
            this.fCreateInstance = "no";
        }
    }

    @ARule(sa=0, desc="Check if at least 1 onAlarm/onMessage is present in a <pick>", author="michal.chmielewski@oracle.com", date="01/15/2007", errors="BPELC__AT_LEAST_ONE")
    public void rule_CheckOnMessagesOnAlarms_1() {
        int count = this.fOnMessages + this.fOnAlarms;
        if (count == 0) {
            IProblem problem = this.createError();
            problem.fill("BPELC__AT_LEAST_ONE", this.toString(this.mNode.nodeName()), 1, CHILDREN, 0);
        }
    }

    @ARule(sa=62, desc="When createInstance is set to yes, onAlarm must not be there.", author="michal.chmielewski@oracle.com", date="01/10/2007", errors="BPELC_PICK__ON_ALARM")
    public void rule_CheckNoAlaram_2() {
        if ("yes".equals(this.fCreateInstance) && this.fOnAlarms > 0) {
            IProblem problem = this.createError();
            problem.fill("BPELC_PICK__ON_ALARM", this.toString(this.mNode.nodeName()), AT_CREATE_INSTANCE, this.fCreateInstance);
        }
    }

    @ARule(sa=56, desc="Check if this pick activity is positioned correctly", author="michal.chmielewski@oracle.com", date="01/10/2007", errors="BPELC__START_ACTIVITY")
    public void rule_CheckIfStartActivity_3() {
        if ("no".equals(this.fCreateInstance)) {
            return;
        }
        this.checkStartActivityPositioning();
        List starts = this.getValue(this.mNode.rootNode(), "start.activities", null);
        starts.add(this.mNode);
    }
}

