/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal.util.gradle;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.buildship.core.internal.util.gradle.Path;
import org.gradle.tooling.model.HierarchicalElement;
import org.gradle.tooling.model.eclipse.EclipseProject;

public class HierarchicalElementUtils {
    private HierarchicalElementUtils() {
    }

    public static <T extends HierarchicalElement> T getRoot(T model) {
        Object root = model;
        while (root.getParent() != null) {
            root = root.getParent();
        }
        return root;
    }

    public static List<EclipseProject> getAll(EclipseProject model) {
        return HierarchicalElementUtils.getAll(model, EclipseProjectComparator.INSTANCE);
    }

    static <T extends HierarchicalElement> List<T> getAll(T model, Comparator<? super T> comparator) {
        ArrayList all = Lists.newArrayList();
        HierarchicalElementUtils.addRecursively(model, all);
        Collections.sort(all, comparator);
        return ImmutableList.copyOf((Collection)all);
    }

    private static <T extends HierarchicalElement> void addRecursively(T node, List<T> nodes) {
        nodes.add(node);
        for (HierarchicalElement child : node.getChildren()) {
            HierarchicalElementUtils.addRecursively(child, nodes);
        }
    }

    static enum EclipseProjectComparator implements Comparator<EclipseProject>
    {
        INSTANCE;


        @Override
        public int compare(EclipseProject o1, EclipseProject o2) {
            Path p1 = Path.from(o1.getGradleProject().getPath());
            Path p2 = Path.from(o2.getGradleProject().getPath());
            return p1.compareTo(p2);
        }
    }
}

