/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eef.core.internal.controllers;

import java.util.HashMap;
import java.util.Optional;
import java.util.function.Consumer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.eef.EEFHyperlinkDescription;
import org.eclipse.eef.EEFWidgetAction;
import org.eclipse.eef.EEFWidgetDescription;
import org.eclipse.eef.EefPackage;
import org.eclipse.eef.common.api.utils.Util;
import org.eclipse.eef.core.api.EditingContextAdapter;
import org.eclipse.eef.core.api.controllers.AbstractEEFOnClickController;
import org.eclipse.eef.core.api.controllers.IEEFHyperlinkController;
import org.eclipse.eef.core.api.utils.EvalFactory;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.sirius.common.interpreter.api.IInterpreter;
import org.eclipse.sirius.common.interpreter.api.IVariableManager;

public class EEFHyperlinkController
extends AbstractEEFOnClickController
implements IEEFHyperlinkController {
    private final EEFHyperlinkDescription description;
    private Consumer<Object> newValueConsumer;

    public EEFHyperlinkController(EEFHyperlinkDescription description, IVariableManager variableManager, IInterpreter interpreter, EditingContextAdapter editingContextAdapter) {
        super(variableManager, interpreter, editingContextAdapter);
        this.description = description;
    }

    @Override
    public void refresh() {
        super.refresh();
        String valueExpression = this.description.getValueExpression();
        Optional.ofNullable(this.newValueConsumer).ifPresent(consumer -> this.newEval().call(valueExpression, (Consumer<Object>)consumer));
    }

    @Override
    public String computeDisplayValue(Object value) {
        String displayExpression = this.description.getDisplayExpression();
        String text = null;
        if (!Util.isBlank((String)displayExpression)) {
            HashMap<String, Object> variables = new HashMap<String, Object>();
            variables.putAll(this.variableManager.getVariables());
            variables.put("value", value);
            text = EvalFactory.of(this.interpreter, variables).logIfInvalidType(String.class).evaluate(displayExpression);
        }
        return Optional.ofNullable(text).orElse("");
    }

    @Override
    public void onNewValue(Consumer<Object> consumer) {
        this.newValueConsumer = consumer;
    }

    @Override
    public void removeNewValueConsumer() {
        this.newValueConsumer = null;
    }

    @Override
    protected EEFWidgetDescription getDescription() {
        return this.description;
    }

    @Override
    protected String getOnClickExpression() {
        return this.description.getOnClickExpression();
    }

    @Override
    public IStatus action(EEFWidgetAction action) {
        return this.editingContextAdapter.performModelChange(() -> {
            String expression = action.getActionExpression();
            EAttribute eAttribute = EefPackage.Literals.EEF_WIDGET_ACTION__ACTION_EXPRESSION;
            HashMap<String, Object> variables = new HashMap<String, Object>();
            variables.putAll(this.variableManager.getVariables());
            EvalFactory.of(this.interpreter, variables).logIfBlank(eAttribute).call(expression);
        });
    }
}

