/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.domain;

import org.eclipse.egf.domain.Activator;
import org.eclipse.egf.domain.DomainException;
import org.eclipse.egf.domain.IDomainHelper;
import org.eclipse.egf.domain.Messages;
import org.eclipse.egf.model.domain.Domain;
import org.eclipse.egf.model.domain.LoadableDomain;
import org.eclipse.osgi.util.NLS;

public abstract class LoadableDomainHelper
implements IDomainHelper {
    protected abstract boolean doLoadDomain(LoadableDomain var1) throws DomainException;

    protected abstract boolean doUnLoadDomain(LoadableDomain var1) throws DomainException;

    public boolean loadDomain(Domain domain) throws DomainException {
        if (domain instanceof LoadableDomain) {
            LoadableDomain lDomain = (LoadableDomain)domain;
            if (lDomain.isLoaded()) {
                throw new DomainException(Messages.bind((String)Messages.Load_Domain_error1, (Object)domain.eClass().getName(), (Object)domain.getName()));
            }
            return this.doLoadDomain(lDomain);
        }
        return true;
    }

    public boolean unLoadDomain(Domain domain) throws DomainException {
        if (domain instanceof LoadableDomain) {
            LoadableDomain lDomain = (LoadableDomain)domain;
            if (!lDomain.isLoaded()) {
                Activator.getDefault().logWarning(NLS.bind((String)Messages.unload_error1, (Object)domain.getName()));
            } else {
                return this.doUnLoadDomain(lDomain);
            }
        }
        return true;
    }
}

