/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.language.fontname;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Stretch implements Enumerator
{
    NORMAL(0, "NORMAL", ""),
    ULTRA_CONDENSED(1, "ULTRA_CONDENSED", "Ultra-Condensed"),
    EXTRA_CONDENSED(2, "EXTRA_CONDENSED", "Extra-Condensed"),
    CONDENSED(3, "CONDENSED", "Condensed"),
    SEMI_CONDENSED(4, "SEMI_CONDENSED", "Semi-Condensed"),
    SEMI_EXPANDED(5, "SEMI_EXPANDED", "Semi-Expanded"),
    EXPANDED(6, "EXPANDED", "Expanded"),
    EXTRA_EXPANDED(7, "EXTRA_EXPANDED", "Extra-Expanded"),
    ULTRA_EXPANDED(8, "ULTRA_EXPANDED", "Ultra-Expanded");

    public static final int NORMAL_VALUE = 0;
    public static final int ULTRA_CONDENSED_VALUE = 1;
    public static final int EXTRA_CONDENSED_VALUE = 2;
    public static final int CONDENSED_VALUE = 3;
    public static final int SEMI_CONDENSED_VALUE = 4;
    public static final int SEMI_EXPANDED_VALUE = 5;
    public static final int EXPANDED_VALUE = 6;
    public static final int EXTRA_EXPANDED_VALUE = 7;
    public static final int ULTRA_EXPANDED_VALUE = 8;
    private static final Stretch[] VALUES_ARRAY;
    public static final List<Stretch> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Stretch[]{NORMAL, ULTRA_CONDENSED, EXTRA_CONDENSED, CONDENSED, SEMI_CONDENSED, SEMI_EXPANDED, EXPANDED, EXTRA_EXPANDED, ULTRA_EXPANDED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Stretch get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Stretch result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Stretch getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Stretch result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Stretch get(int value) {
        switch (value) {
            case 0: {
                return NORMAL;
            }
            case 1: {
                return ULTRA_CONDENSED;
            }
            case 2: {
                return EXTRA_CONDENSED;
            }
            case 3: {
                return CONDENSED;
            }
            case 4: {
                return SEMI_CONDENSED;
            }
            case 5: {
                return SEMI_EXPANDED;
            }
            case 6: {
                return EXPANDED;
            }
            case 7: {
                return EXTRA_EXPANDED;
            }
            case 8: {
                return ULTRA_EXPANDED;
            }
        }
        return null;
    }

    private Stretch(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

