/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.common.util;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.eclipse.jubula.rc.common.adaptable.AdapterFactoryRegistry;
import org.eclipse.jubula.rc.common.adaptable.IPropertyValue;
import org.eclipse.jubula.rc.common.exception.RobotException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyUtil {
    public static final char[] INVALID_XML_CHARS = new char[1];
    private static Logger log = LoggerFactory.getLogger(PropertyUtil.class);

    private PropertyUtil() {
    }

    public static String getPropertyValue(Object object, String propertyName) throws RobotException {
        String propertyValue = "";
        Validate.notNull((Object)object, (String)"Tested component must not be null");
        try {
            IPropertyValue propertyValueAdapter;
            ArrayList<String> path = new ArrayList<String>(Arrays.asList(propertyName.split("/")));
            Object prop = path.size() > 0 ? PropertyUtil.getPropertyByPathOrMethod(object, path, 0) : null;
            propertyValue = prop != null ? ((propertyValueAdapter = (IPropertyValue)AdapterFactoryRegistry.getInstance().getAdapter(IPropertyValue.class, prop)) != null ? propertyValueAdapter.getStringRepresentation(prop) : String.valueOf(prop)) : String.valueOf(prop);
        }
        catch (IllegalAccessException e) {
            throw new RobotException(e);
        }
        catch (InvocationTargetException e) {
            throw new RobotException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RobotException(e);
        }
        if (StringUtils.containsAny((String)propertyValue, (char[])INVALID_XML_CHARS)) {
            char[] cArray = INVALID_XML_CHARS;
            int n = INVALID_XML_CHARS.length;
            int n2 = 0;
            while (n2 < n) {
                Character c = Character.valueOf(cArray[n2]);
                propertyValue = StringUtils.remove((String)propertyValue, (char)c.charValue());
                ++n2;
            }
        }
        return propertyValue;
    }

    private static Object getPropertyByPathOrMethod(Object object, ArrayList<String> path, int index) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        String name = path.get(index);
        if (index >= 0 && index < path.size() - 1) {
            if (name.endsWith("()")) {
                return PropertyUtil.getPropertyByPathOrMethod(MethodUtils.invokeExactMethod((Object)object, (String)name.replace("()", ""), null), path, index + 1);
            }
            return PropertyUtil.getPropertyByPathOrMethod(PropertyUtils.getProperty((Object)object, (String)name), path, index + 1);
        }
        if (index >= 0 && index == path.size() - 1) {
            if (name.endsWith("()")) {
                return MethodUtils.invokeExactMethod((Object)object, (String)name.replace("()", ""), null);
            }
            return PropertyUtils.getProperty((Object)object, (String)path.get(index));
        }
        return null;
    }

    public static Map<String, String> getMapOfComponentProperties(Object currComp) {
        PropertyDescriptor[] propertyDescriptors = PropertyUtils.getPropertyDescriptors((Object)currComp);
        TreeMap<String, String> componentProperties = new TreeMap<String, String>();
        int i = 0;
        while (i < propertyDescriptors.length) {
            PropertyDescriptor pd = propertyDescriptors[i];
            String propertyName = pd.getName();
            try {
                Method readMethod = pd.getReadMethod();
                if (readMethod != null) {
                    componentProperties.put(propertyName, PropertyUtil.getPropertyValue(currComp, propertyName));
                } else {
                    componentProperties.put(propertyName, "This property is not readable");
                }
            }
            catch (Exception e) {
                log.warn("Property " + propertyName + " of " + currComp.toString() + " caused an exception while being read.", (Throwable)e);
                componentProperties.put(propertyName, "---Error---");
            }
            ++i;
        }
        return componentProperties;
    }
}

