/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpm.rpmlint.actions;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.linuxtools.internal.rpm.rpmlint.RpmlintLog;
import org.eclipse.linuxtools.internal.rpm.rpmlint.actions.Messages;
import org.eclipse.linuxtools.rpm.core.utils.Utils;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class RunRpmlintAction
extends AbstractHandler {
    public Object execute(ExecutionEvent event) {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            for (Object element : ((IStructuredSelection)selection).toList()) {
                IFile rpmFile = null;
                if (element instanceof IFile) {
                    rpmFile = (IFile)element;
                } else if (element instanceof IAdaptable) {
                    rpmFile = (IFile)((IAdaptable)element).getAdapter(IFile.class);
                }
                if (rpmFile == null) continue;
                RunRpmlintAction.runRpmlint(rpmFile.getLocation().toString());
            }
        } else {
            IEditorPart editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
            if (editor != null) {
                IEditorInput editorInput = editor.getEditorInput();
                if (editorInput instanceof IFileEditorInput) {
                    RunRpmlintAction.runRpmlint(((IFileEditorInput)editorInput).getFile().getLocation().toString());
                } else if (editorInput instanceof IURIEditorInput) {
                    RunRpmlintAction.runRpmlint(((IURIEditorInput)editorInput).getURI().getPath());
                }
            }
        }
        return null;
    }

    private static void runRpmlint(String location) {
        String rpmlintPath = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.linuxtools.rpm.rpmlint").getString("RpmlintPath");
        try {
            if (Files.exists(Paths.get(rpmlintPath, new String[0]), new LinkOption[0])) {
                String output = Utils.runCommandToString((String[])new String[]{rpmlintPath, "-i", location});
                MessageConsole myConsole = RunRpmlintAction.findConsole(Messages.RunRpmlintAction_0);
                MessageConsoleStream out = myConsole.newMessageStream();
                myConsole.clearConsole();
                myConsole.activate();
                out.println(output);
            } else {
                Status warning = new Status(2, "org.eclipse.linuxtools.rpm.rpmlint", 1, Messages.RunRpmlintAction_1, null);
                ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.RunRpmlintAction_2, null, (IStatus)warning);
            }
        }
        catch (IOException e) {
            RpmlintLog.logError(e);
        }
    }

    private static MessageConsole findConsole(String name) {
        ConsolePlugin plugin = ConsolePlugin.getDefault();
        IConsoleManager conMan = plugin.getConsoleManager();
        IConsole[] existing = conMan.getConsoles();
        int i = 0;
        while (i < existing.length) {
            if (name.equals(existing[i].getName())) {
                return (MessageConsole)existing[i];
            }
            ++i;
        }
        MessageConsole myConsole = new MessageConsole(name, null);
        conMan.addConsoles(new IConsole[]{myConsole});
        return myConsole;
    }
}

