/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.graphing.ui.wizards.filter;

import org.eclipse.linuxtools.internal.systemtap.graphing.ui.Localization;
import org.eclipse.linuxtools.systemtap.graphing.core.aggregates.AverageAggregate;
import org.eclipse.linuxtools.systemtap.graphing.core.aggregates.CountAggregate;
import org.eclipse.linuxtools.systemtap.graphing.core.aggregates.IDataAggregate;
import org.eclipse.linuxtools.systemtap.graphing.core.aggregates.MaxAggregate;
import org.eclipse.linuxtools.systemtap.graphing.core.aggregates.MinAggregate;
import org.eclipse.linuxtools.systemtap.graphing.core.aggregates.SumAggregate;

public final class AggregateFactory {
    private static String[] AGGREGATE_NAMES = new String[]{Localization.getString("AggregateFactory.AverageAggregate"), Localization.getString("AggregateFactory.CountAggregate"), Localization.getString("AggregateFactory.MaxAggregate"), Localization.getString("AggregateFactory.MinAggregate"), Localization.getString("AggregateFactory.SumAggregate")};
    private static String[] AGGREGATION_DESCRIPTIONS = new String[]{Localization.getString("AggregateFactory.AverageDescription"), Localization.getString("AggregateFactory.CountDescription"), Localization.getString("AggregateFactory.MaxDescription"), Localization.getString("AggregateFactory.MinDescription"), Localization.getString("AggregateFactory.SumDescription")};
    static String[] AGGREGATES = new String[]{"org.eclipse.linuxtools.systemtap.graphing.core.aggregates.AverageAggregate", "org.eclipse.linuxtools.systemtap.graphing.core.aggregates.CountAggregate", "org.eclipse.linuxtools.systemtap.graphing.core.aggregates.MaxAggregate", "org.eclipse.linuxtools.systemtap.graphing.core.aggregates.MinAggregate", "org.eclipse.linuxtools.systemtap.graphing.core.aggregates.SumAggregate"};

    private AggregateFactory() {
    }

    public static String getAggregateName(String id) {
        int index = AggregateFactory.getIndex(id);
        if (index >= 0) {
            return AGGREGATE_NAMES[index];
        }
        return null;
    }

    public static String getAggregateDescription(String id) {
        int index = AggregateFactory.getIndex(id);
        if (index >= 0) {
            return AGGREGATION_DESCRIPTIONS[index];
        }
        return null;
    }

    private static int getIndex(String id) {
        int i = 0;
        while (i < AGGREGATES.length) {
            if (id.equals(AGGREGATES[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static IDataAggregate createAggregate(String id) {
        switch (AggregateFactory.getIndex(id)) {
            case 0: {
                return new AverageAggregate();
            }
            case 1: {
                return new CountAggregate();
            }
            case 2: {
                return new MaxAggregate();
            }
            case 3: {
                return new MinAggregate();
            }
            case 4: {
                return new SumAggregate();
            }
        }
        return null;
    }
}

