/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.facet.custom.ui.internal;

import java.net.URL;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.modisco.facet.custom.ui.internal.Activator;
import org.eclipse.modisco.facet.util.core.Logger;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public final class ImageProvider {
    private static ImageProvider instance;
    private Image uiCustomIcon = null;
    private Image grayedUiCustomIcon;
    private Image linkIcon = null;
    private Image linkUniDirIcon = null;
    private Image linkFacetIcon = null;
    private Image aggregIcon = null;
    private Image aggregUniDirIcon = null;
    private Image invAggregIcon = null;
    private Image attributeIcon = null;
    private Image attribFacetIcon = null;
    private Image featureIcon = null;
    private static final String UI_CUSTOM = "icons/uiCustom.gif";
    private static final String AGGREG_UNIDIR = "icons/aggreg_unidir.gif";
    private static final String AGGREG_ICON_PATH = "icons/aggreg.gif";
    private static final String ATTRIBUTE_FACET = "icons/attribute_facet.gif";
    private static final String ATTRIBUTE = "icons/attributes.gif";
    private static final String INV_AGGREG = "icons/inv_aggreg.gif";
    private static final String LINK_FACET = "icons/link_unidir_facet.gif";
    private static final String LINK_UNIDIR = "icons/link_unidir.gif";
    private static final String LINK_ICON_PATH = "icons/link.gif";
    private static final String FEATURE_ICON_PATH = "icons/feature.gif";

    private ImageProvider() {
    }

    public static ImageProvider getInstance() {
        if (instance == null) {
            instance = new ImageProvider();
        }
        return instance;
    }

    private static ImageDescriptor createImageDescriptor(String resourcePath) {
        ImageDescriptor result;
        URL url = Activator.getDefault().getBundle().getResource(resourcePath);
        if (url == null) {
            Logger.logError((String)NLS.bind((String)"Resource not found: {0}", (Object)resourcePath), (Plugin)Activator.getDefault());
            result = ImageDescriptor.getMissingImageDescriptor();
        } else {
            result = ImageDescriptor.createFromURL((URL)url);
        }
        return result;
    }

    public Image getUiCustomIcon() {
        if (this.uiCustomIcon == null) {
            this.uiCustomIcon = ImageProvider.createImageDescriptor(UI_CUSTOM).createImage();
        }
        return this.uiCustomIcon;
    }

    public Image getGrayedUiCustomIcon() {
        if (this.grayedUiCustomIcon == null) {
            this.grayedUiCustomIcon = new Image((Device)Display.getCurrent(), this.getUiCustomIcon(), 2);
        }
        return this.grayedUiCustomIcon;
    }

    public Image getLinkIcon() {
        if (this.linkIcon == null) {
            this.linkIcon = ImageProvider.createImageDescriptor(LINK_ICON_PATH).createImage();
        }
        return this.linkIcon;
    }

    public Image getUnidirectionalLinkIcon() {
        if (this.linkUniDirIcon == null) {
            this.linkUniDirIcon = ImageProvider.createImageDescriptor(LINK_UNIDIR).createImage();
        }
        return this.linkUniDirIcon;
    }

    public Image getFacetLinkIcon() {
        if (this.linkFacetIcon == null) {
            this.linkFacetIcon = ImageProvider.createImageDescriptor(LINK_FACET).createImage();
        }
        return this.linkFacetIcon;
    }

    public Image getAggregIcon() {
        if (this.aggregIcon == null) {
            this.aggregIcon = ImageProvider.createImageDescriptor(AGGREG_ICON_PATH).createImage();
        }
        return this.aggregIcon;
    }

    public Image getUnidirectionalAggregIcon() {
        if (this.aggregUniDirIcon == null) {
            this.aggregUniDirIcon = ImageProvider.createImageDescriptor(AGGREG_UNIDIR).createImage();
        }
        return this.aggregUniDirIcon;
    }

    public Image getInvAggregIcon() {
        if (this.invAggregIcon == null) {
            this.invAggregIcon = ImageProvider.createImageDescriptor(INV_AGGREG).createImage();
        }
        return this.invAggregIcon;
    }

    public Image getAttributeIcon() {
        if (this.attributeIcon == null) {
            this.attributeIcon = ImageProvider.createImageDescriptor(ATTRIBUTE).createImage();
        }
        return this.attributeIcon;
    }

    public Image getFacetAttributeIcon() {
        if (this.attribFacetIcon == null) {
            this.attribFacetIcon = ImageProvider.createImageDescriptor(ATTRIBUTE_FACET).createImage();
        }
        return this.attribFacetIcon;
    }

    public Image getFeatureIcon() {
        if (this.featureIcon == null) {
            this.featureIcon = ImageProvider.createImageDescriptor(FEATURE_ICON_PATH).createImage();
        }
        return this.featureIcon;
    }
}

