/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.trac.core.client;

import java.io.IOException;
import java.net.Proxy;
import java.net.URL;
import java.util.HashMap;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.PostMethod;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.mylyn.commons.core.CoreUtil;
import org.eclipse.mylyn.commons.net.AbstractWebLocation;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.WebUtil;
import org.eclipse.mylyn.internal.trac.core.client.ITracClient;
import org.eclipse.mylyn.internal.trac.core.client.TracClientData;
import org.eclipse.mylyn.internal.trac.core.client.TracException;
import org.eclipse.mylyn.internal.trac.core.client.TracLoginException;
import org.eclipse.mylyn.internal.trac.core.model.TracComponent;
import org.eclipse.mylyn.internal.trac.core.model.TracMilestone;
import org.eclipse.mylyn.internal.trac.core.model.TracPriority;
import org.eclipse.mylyn.internal.trac.core.model.TracSeverity;
import org.eclipse.mylyn.internal.trac.core.model.TracTicketField;
import org.eclipse.mylyn.internal.trac.core.model.TracTicketResolution;
import org.eclipse.mylyn.internal.trac.core.model.TracTicketStatus;
import org.eclipse.mylyn.internal.trac.core.model.TracTicketType;
import org.eclipse.mylyn.internal.trac.core.model.TracVersion;

public abstract class AbstractTracClient
implements ITracClient {
    public static final int SC_CERT_AUTH_FAILED = 499;
    protected static final boolean DEBUG_AUTH = Boolean.valueOf(Platform.getDebugOption((String)"org.eclipse.mylyn.trac.core/debug/authentication"));
    protected static final String USER_AGENT = "TracConnector";
    private static final String LOGIN_COOKIE_NAME = "trac_auth";
    protected final String repositoryUrl;
    protected final ITracClient.Version version;
    protected final AbstractWebLocation location;
    protected TracClientData data;

    public AbstractTracClient(URL repositoryUrl, ITracClient.Version version, String username, String password, Proxy proxy) {
        this.repositoryUrl = repositoryUrl.toString();
        this.version = version;
        this.location = null;
        this.data = new TracClientData();
    }

    public AbstractTracClient(AbstractWebLocation location, ITracClient.Version version) {
        this.location = location;
        this.version = version;
        this.repositoryUrl = location.getUrl();
        this.data = new TracClientData();
    }

    protected HttpClient createHttpClient() {
        HttpClient httpClient = new HttpClient();
        httpClient.setHttpConnectionManager(WebUtil.getConnectionManager());
        httpClient.getParams().setCookiePolicy("rfc2109");
        WebUtil.configureHttpClient((HttpClient)httpClient, (String)USER_AGENT);
        return httpClient;
    }

    @Override
    public ITracClient.Version getAccessMode() {
        return this.version;
    }

    protected boolean credentialsValid(AuthenticationCredentials credentials) {
        return credentials != null && credentials.getUserName().length() > 0;
    }

    protected void authenticateAccountManager(HttpClient httpClient, HostConfiguration hostConfiguration, AuthenticationCredentials credentials, IProgressMonitor monitor) throws IOException, TracLoginException {
        String formToken = this.getFormToken(httpClient);
        this.authenticateAccountManagerInternal(httpClient, hostConfiguration, credentials, monitor, formToken);
        String newFormToken = this.getFormToken(httpClient);
        if (formToken.length() == 0 && !formToken.equals(newFormToken)) {
            this.authenticateAccountManagerInternal(httpClient, hostConfiguration, credentials, monitor, newFormToken);
        }
    }

    public void authenticateAccountManagerInternal(HttpClient httpClient, HostConfiguration hostConfiguration, AuthenticationCredentials credentials, IProgressMonitor monitor, String formToken) throws IOException, TracLoginException {
        PostMethod post = new PostMethod(WebUtil.getRequestPath((String)(String.valueOf(this.repositoryUrl) + "/login")));
        post.setFollowRedirects(false);
        NameValuePair[] data = new NameValuePair[]{new NameValuePair("referer", ""), new NameValuePair("user", credentials.getUserName()), new NameValuePair("password", credentials.getPassword()), new NameValuePair("__FORM_TOKEN", formToken)};
        post.setRequestBody(data);
        try {
            if (DEBUG_AUTH) {
                System.err.println(String.valueOf(this.location.getUrl()) + ": Attempting form-based account manager authentication");
            }
            int code = WebUtil.execute((HttpClient)httpClient, (HostConfiguration)hostConfiguration, (HttpMethod)post, (IProgressMonitor)monitor);
            if (DEBUG_AUTH) {
                System.err.println(String.valueOf(this.location.getUrl()) + ": Received account manager response (" + code + ")");
            }
            if (code == 200) {
                throw new TracLoginException();
            }
        }
        finally {
            WebUtil.releaseConnection((HttpMethodBase)post, (IProgressMonitor)monitor);
        }
    }

    private String getFormToken(HttpClient httpClient) {
        Cookie[] cookies;
        Cookie[] cookieArray = cookies = httpClient.getState().getCookies();
        int n = cookies.length;
        int n2 = 0;
        while (n2 < n) {
            Cookie cookie = cookieArray[n2];
            if ("trac_form_token".equals(cookie.getName())) {
                return cookie.getValue();
            }
            ++n2;
        }
        return "";
    }

    protected void validateAuthenticationState(HttpClient httpClient) throws TracLoginException {
        Cookie[] cookies;
        Cookie[] cookieArray = cookies = httpClient.getState().getCookies();
        int n = cookies.length;
        int n2 = 0;
        while (n2 < n) {
            Cookie cookie = cookieArray[n2];
            if (LOGIN_COOKIE_NAME.equals(cookie.getName())) {
                return;
            }
            ++n2;
        }
        if (CoreUtil.TEST_MODE) {
            System.err.println(" Authentication failed: " + httpClient.getState());
        }
        throw new TracLoginException();
    }

    @Override
    public TracComponent[] getComponents() {
        return this.data.components != null ? this.data.components.toArray(new TracComponent[0]) : null;
    }

    @Override
    public TracMilestone[] getMilestones() {
        return this.data.milestones != null ? this.data.milestones.toArray(new TracMilestone[0]) : null;
    }

    @Override
    public TracPriority[] getPriorities() {
        return this.data.priorities != null ? this.data.priorities.toArray(new TracPriority[0]) : null;
    }

    @Override
    public TracSeverity[] getSeverities() {
        return this.data.severities != null ? this.data.severities.toArray(new TracSeverity[0]) : null;
    }

    @Override
    public TracTicketField[] getTicketFields() {
        return this.data.ticketFields != null ? this.data.ticketFields.toArray(new TracTicketField[0]) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TracTicketField getTicketFieldByName(String name) {
        if (this.data.ticketFields != null) {
            AbstractTracClient abstractTracClient = this;
            synchronized (abstractTracClient) {
                if (this.data.ticketFieldByName == null) {
                    this.data.ticketFieldByName = new HashMap<String, TracTicketField>();
                    for (TracTicketField field : this.data.ticketFields) {
                        this.data.ticketFieldByName.put(field.getName(), field);
                    }
                }
                return this.data.ticketFieldByName.get(name);
            }
        }
        return null;
    }

    @Override
    public TracTicketResolution[] getTicketResolutions() {
        return this.data.ticketResolutions != null ? this.data.ticketResolutions.toArray(new TracTicketResolution[0]) : null;
    }

    @Override
    public TracTicketStatus[] getTicketStatus() {
        return this.data.ticketStatus != null ? this.data.ticketStatus.toArray(new TracTicketStatus[0]) : null;
    }

    @Override
    public TracTicketType[] getTicketTypes() {
        return this.data.ticketTypes != null ? this.data.ticketTypes.toArray(new TracTicketType[0]) : null;
    }

    @Override
    public TracVersion[] getVersions() {
        return this.data.versions != null ? this.data.versions.toArray(new TracVersion[0]) : null;
    }

    @Override
    public boolean hasAttributes() {
        return this.data.lastUpdate != 0L;
    }

    @Override
    public void updateAttributes(IProgressMonitor monitor, boolean force) throws TracException {
        if (!this.hasAttributes() || force) {
            this.updateAttributes(monitor);
            this.data.lastUpdate = System.currentTimeMillis();
        }
    }

    public abstract void updateAttributes(IProgressMonitor var1) throws TracException;

    @Override
    public void setData(TracClientData data) {
        this.data = data;
    }

    public String[] getDefaultTicketResolutions() {
        return new String[]{"fixed", "invalid", "wontfix", "duplicate", "worksforme"};
    }

    public String[] getDefaultTicketActions(String status) {
        if ("new".equals(status)) {
            return new String[]{"leave", "resolve", "reassign", "accept"};
        }
        if ("assigned".equals(status)) {
            return new String[]{"leave", "resolve", "reassign"};
        }
        if ("reopened".equals(status)) {
            return new String[]{"leave", "resolve", "reassign"};
        }
        if ("closed".equals(status)) {
            return new String[]{"leave", "reopen"};
        }
        return null;
    }

    @Override
    public String getUrl() {
        return this.repositoryUrl;
    }
}

