/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.dnd.strategy.instancespecification.ui;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.papyrus.uml.diagram.dnd.strategy.instancespecification.ui.ClassifierPropertiesContentProvider;
import org.eclipse.papyrus.uml.diagram.dnd.strategy.instancespecification.ui.ClassifierPropertiesLabelProvider;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Slot;

public class SlotSelectionDialog
extends SelectionDialog {
    private final InstanceSpecification specification;
    private final List<Classifier> classifiers;
    private final Map<Property, Boolean> properties;

    public SlotSelectionDialog(Shell parentShell, InstanceSpecification specification, List<Classifier> classifiers) {
        super(parentShell);
        this.specification = specification;
        this.classifiers = classifiers;
        this.properties = new LinkedHashMap<Property, Boolean>();
    }

    public void create() {
        this.setTitle("Select the slots to create");
        super.create();
        this.getShell().setImage(Activator.getDefault().getImage("icons/papyrus.png"));
        Composite parent = this.getDialogArea();
        Label label = new Label(parent, 0);
        label.setText("Select the slots you wish to create. Existing slots cannot be removed here");
        TreeViewer viewer = new TreeViewer(parent, 2816);
        viewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        Tree tree = viewer.getTree();
        TableLayout layout = new TableLayout();
        TreeColumn propertyColumn = new TreeColumn(tree, 0x1000000);
        propertyColumn.setText("Property");
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(30, 150, true));
        TreeColumn ownerColumn = new TreeColumn(tree, 0x1000000);
        ownerColumn.setText("Qualified name");
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(60, 300, true));
        TreeColumn checkColumn = new TreeColumn(tree, 0x1000000);
        checkColumn.setText("Create slot");
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(10, 70, true));
        tree.setLayout((Layout)layout);
        tree.setHeaderVisible(true);
        viewer.setContentProvider((IContentProvider)new ClassifierPropertiesContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new ClassifierPropertiesLabelProvider());
        viewer.setInput(this.classifiers);
        viewer.expandAll();
        TreeItem[] treeItemArray = tree.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem classifierItem = treeItemArray[n2];
            TreeItem[] treeItemArray2 = classifierItem.getItems();
            int n3 = treeItemArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                TreeItem propertyItem = treeItemArray2[n4];
                final Property property = (Property)propertyItem.getData();
                this.properties.put(property, this.select(property));
                final Button checkbox = new Button((Composite)tree, 32);
                checkbox.setSelection(true);
                checkbox.setEnabled(this.select(property));
                checkbox.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        SlotSelectionDialog.this.properties.put(property, checkbox.getSelection());
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
                TreeEditor editor = new TreeEditor(tree);
                editor.horizontalAlignment = 0x1000000;
                editor.grabHorizontal = true;
                editor.setEditor((Control)checkbox, propertyItem, 2);
                ++n4;
            }
            ++n2;
        }
        parent.layout();
        this.getShell().pack();
    }

    protected boolean select(Property property) {
        for (Slot slot : this.specification.getSlots()) {
            if (slot.getDefiningFeature() != property) continue;
            return false;
        }
        return true;
    }

    protected void okPressed() {
        LinkedList<Property> result = new LinkedList<Property>();
        for (Map.Entry<Property, Boolean> entry : this.properties.entrySet()) {
            if (!entry.getValue().booleanValue()) continue;
            result.add(entry.getKey());
        }
        this.setResult(result);
        super.okPressed();
    }

    public Composite getDialogArea() {
        return (Composite)super.getDialogArea();
    }

    public boolean isResizable() {
        return true;
    }
}

