/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.figures;

import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;
import org.eclipse.papyrus.uml.diagram.sequence.anchors.CenterAnchor;

public class DestructionEventFigure
extends DefaultSizeNodeFigure {
    private int lineWidth = 1;

    public DestructionEventFigure() {
        super(40, 40);
    }

    protected void paintFigure(Graphics graphics) {
        super.paintFigure(graphics);
        graphics.pushState();
        graphics.setLineWidth(2);
        graphics.drawLine(this.bounds.x, this.bounds.y, this.bounds.x + this.bounds.width, this.bounds.y + this.bounds.height);
        graphics.drawLine(this.bounds.x, this.bounds.y + this.bounds.height, this.bounds.x + this.bounds.width, this.bounds.y);
        graphics.popState();
    }

    public void setLineWidth(int w) {
        if (this.lineWidth == w || w < 0) {
            return;
        }
        this.lineWidth = w;
        this.repaint();
    }

    public ConnectionAnchor getConnectionAnchor(String terminal) {
        if ("center".equals(terminal)) {
            return new CenterAnchor((IFigure)this);
        }
        return super.getConnectionAnchor(terminal);
    }

    public String getConnectionAnchorTerminal(ConnectionAnchor c) {
        if (c instanceof CenterAnchor) {
            return "center";
        }
        return super.getConnectionAnchorTerminal(c);
    }
}

