/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.lml.core.model;

public class LMLColor {
    protected int r;
    protected int g;
    protected int b;
    public static final LMLColor white;
    public static final LMLColor WHITE;
    public static final LMLColor lightGray;
    public static final LMLColor LIGHT_GRAY;
    public static final LMLColor gray;
    public static final LMLColor GRAY;
    public static final LMLColor darkGray;
    public static final LMLColor DARK_GRAY;
    public static final LMLColor black;
    public static final LMLColor BLACK;
    public static final LMLColor red;
    public static final LMLColor RED;
    public static final LMLColor pink;
    public static final LMLColor PINK;
    public static final LMLColor orange;
    public static final LMLColor ORANGE;
    public static final LMLColor yellow;
    public static final LMLColor YELLOW;
    public static final LMLColor green;
    public static final LMLColor GREEN;
    public static final LMLColor magenta;
    public static final LMLColor MAGENTA;
    public static final LMLColor cyan;
    public static final LMLColor CYAN;
    public static final LMLColor blue;
    public static final LMLColor BLUE;

    static {
        WHITE = white = new LMLColor(255, 255, 255);
        LIGHT_GRAY = lightGray = new LMLColor(192, 192, 192);
        GRAY = gray = new LMLColor(128, 128, 128);
        DARK_GRAY = darkGray = new LMLColor(64, 64, 64);
        BLACK = black = new LMLColor(0, 0, 0);
        RED = red = new LMLColor(255, 0, 0);
        PINK = pink = new LMLColor(255, 175, 175);
        ORANGE = orange = new LMLColor(255, 200, 0);
        YELLOW = yellow = new LMLColor(255, 255, 0);
        GREEN = green = new LMLColor(0, 255, 0);
        MAGENTA = magenta = new LMLColor(255, 0, 255);
        CYAN = cyan = new LMLColor(0, 255, 255);
        BLUE = blue = new LMLColor(0, 0, 255);
    }

    public LMLColor(int red, int green, int blue) {
        this.r = red;
        this.g = green;
        this.b = blue;
    }

    public LMLColor(String colorstring) {
        LMLColor color = LMLColor.stringToColor(colorstring);
        this.r = color.r;
        this.g = color.g;
        this.b = color.b;
    }

    public int getRed() {
        return this.r;
    }

    public int getGreen() {
        return this.g;
    }

    public int getBlue() {
        return this.b;
    }

    public static LMLColor stringToColor(String colorstring) {
        if (colorstring == null || colorstring.length() == 0) {
            return white;
        }
        if (colorstring.charAt(0) == '#') {
            colorstring = colorstring.substring(1);
        }
        int red = 0;
        int green = 0;
        int blue = 0;
        if (colorstring.length() == 3) {
            red = Integer.parseInt(colorstring.substring(0, 1), 16);
            green = Integer.parseInt(colorstring.substring(1, 2), 16);
            blue = Integer.parseInt(colorstring.substring(2, 3), 16);
            red += 16 * red;
            green += 16 * green;
            blue += 16 * blue;
        } else if (colorstring.length() == 6) {
            red = Integer.parseInt(colorstring.substring(0, 2), 16);
            green = Integer.parseInt(colorstring.substring(2, 4), 16);
            blue = Integer.parseInt(colorstring.substring(4, 6), 16);
        } else {
            return black;
        }
        return new LMLColor(red, green, blue);
    }

    public String toString() {
        return "#" + Integer.toHexString(this.r) + Integer.toHexString(this.g) + Integer.toHexString(this.b);
    }
}

