/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.internal.metamodel.description.operations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerInterpreter;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.EObjectCouple;
import org.eclipse.sirius.common.tools.api.util.RefreshIdsHolder;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramMappingsManager;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramMappingsManagerRegistry;
import org.eclipse.sirius.diagram.business.api.helper.display.DisplayMode;
import org.eclipse.sirius.diagram.business.api.helper.display.DisplayService;
import org.eclipse.sirius.diagram.business.api.helper.display.DisplayServiceManager;
import org.eclipse.sirius.diagram.business.api.helper.graphicalfilters.HideFilterHelper;
import org.eclipse.sirius.diagram.business.api.query.DiagramElementMappingQuery;
import org.eclipse.sirius.diagram.business.api.query.EObjectQuery;
import org.eclipse.sirius.diagram.business.internal.metamodel.description.extensions.INodeMappingExt;
import org.eclipse.sirius.diagram.business.internal.metamodel.description.operations.SiriusElementMappingSpecOperations;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.MappingHelper;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.NodeMappingHelper;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.eclipse.sirius.diagram.description.DescriptionPackage;
import org.eclipse.sirius.diagram.description.NodeMapping;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.tools.api.interpreter.IInterpreterMessages;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.SiriusPlugin;

public final class AbstractNodeMappingSpecOperations {
    private AbstractNodeMappingSpecOperations() {
    }

    public static DDiagramElement findViewNodeFromEObject(AbstractNodeMapping mapping, EObject eObject) {
        return null;
    }

    public static void clearViewNodesDone(AbstractNodeMapping mapping) {
    }

    private static boolean isInstanceOf(AbstractNodeMapping mapping, EObject eObj, String typename) {
        return SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor(eObj).eInstanceOf(eObj, typename);
    }

    private static Iterator<EObject> extEAllContents(AbstractNodeMapping mapping, EObject eObj) {
        ArrayList targetCandidates = new ArrayList();
        ModelAccessor accessor = SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor(eObj);
        Session session = SessionManager.INSTANCE.getSession(eObj);
        if (session != null) {
            for (Resource resource : session.getSemanticResources()) {
                for (EObject root : resource.getContents()) {
                    targetCandidates.addAll(accessor.eAllContents(root, mapping.getDomainClass()));
                }
            }
        }
        return targetCandidates.iterator();
    }

    public static void createBorderingNodes(AbstractNodeMapping mapping, EObject modelElement, DDiagramElement dDiagramElement, Collection filterSemantic, DDiagram diagram) {
        EObject containerVariable = dDiagramElement.getTarget();
        EObjectQuery eObjectQuery = new EObjectQuery(modelElement);
        Session session = eObjectQuery.getSession();
        for (NodeMapping borderMapping : MappingHelper.getAllBorderedNodeMappings(mapping)) {
            if (!new DiagramElementMappingQuery(borderMapping).isSynchronizedAndCreateElement(diagram)) continue;
            Iterator<EObject> it2 = AbstractNodeMappingSpecOperations.getSemanticIterator(borderMapping, modelElement, (EObject)diagram, (EObject)dDiagramElement);
            while (it2.hasNext()) {
                EObject eObj = it2.next();
                if (eObj == null) continue;
                EObjectCouple couple = new EObjectCouple(eObj, (EObject)borderMapping, RefreshIdsHolder.getOrCreateHolder((EObject)diagram));
                if (!AbstractNodeMappingSpecOperations.isInstanceOf(mapping, eObj, borderMapping.getDomainClass()) || !SiriusElementMappingSpecOperations.checkPrecondition(borderMapping, eObj, modelElement, (EObject)dDiagramElement) || filterSemantic.contains(couple)) continue;
                IInterpreter interpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter(eObj);
                DNode newBorderNode = new NodeMappingHelper(interpreter).createNode((INodeMappingExt)borderMapping, eObj, containerVariable, diagram);
                if (dDiagramElement instanceof DNode) {
                    ((DNode)dDiagramElement).getOwnedBorderedNodes().add((Object)newBorderNode);
                } else if (dDiagramElement instanceof DNodeContainer) {
                    ((DNodeContainer)dDiagramElement).getOwnedBorderedNodes().add((Object)newBorderNode);
                }
                AbstractNodeMappingSpecOperations.setInitialVisibility(newBorderNode, diagram, session);
            }
        }
    }

    private static Iterator<EObject> getSemanticIterator(AbstractNodeMapping mapping, EObject context, EObject diagram, EObject containerView) {
        String expression = mapping.getSemanticCandidatesExpression();
        if (context != null && context.eResource() != null && expression != null && !StringUtil.isEmpty((String)expression.trim())) {
            IInterpreter acceleoInterpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter(context);
            RuntimeLoggerInterpreter safeInterpreter = RuntimeLoggerManager.INSTANCE.decorate(acceleoInterpreter);
            acceleoInterpreter.setVariable("viewpoint", (Object)diagram);
            acceleoInterpreter.setVariable("viewPoint", (Object)diagram);
            acceleoInterpreter.setVariable("diagram", (Object)diagram);
            acceleoInterpreter.setVariable("containerView", (Object)containerView);
            Collection resultNode = safeInterpreter.evaluateCollection(context, (EObject)mapping, (EStructuralFeature)DescriptionPackage.eINSTANCE.getDiagramElementMapping_SemanticCandidatesExpression());
            acceleoInterpreter.unSetVariable("diagram");
            acceleoInterpreter.unSetVariable("viewpoint");
            acceleoInterpreter.unSetVariable("viewPoint");
            acceleoInterpreter.unSetVariable("containerView");
            return resultNode.iterator();
        }
        return AbstractNodeMappingSpecOperations.extEAllContents(mapping, context);
    }

    public static String evaluateLabel(IInterpreter interpreter, DSemanticDecorator view, EObject featureOwner, EStructuralFeature featureDescription) {
        String label = null;
        String labelComputationExpression = (String)featureOwner.eGet(featureDescription);
        if (labelComputationExpression != null) {
            try {
                try {
                    interpreter.setVariable("view", (Object)view);
                    label = interpreter.evaluateString(view.getTarget(), labelComputationExpression);
                }
                catch (EvaluationException e) {
                    RuntimeLoggerManager.INSTANCE.error(featureOwner, featureDescription, (Throwable)e);
                    label = IInterpreterMessages.DEFAULT_NAME_ON_FACTORY_EXCEPTION;
                    interpreter.unSetVariable("view");
                }
            }
            finally {
                interpreter.unSetVariable("view");
            }
        }
        return label;
    }

    public static void setInitialVisibility(DDiagramElement diagramElement, DDiagram diagram, Session session) {
        DisplayService service = DisplayServiceManager.INSTANCE.getDisplayService(DisplayMode.CREATION);
        if (service != null && diagramElement != null && diagram != null) {
            DiagramMappingsManager mappingManager = DiagramMappingsManagerRegistry.INSTANCE.getDiagramMappingsManager(session, diagram);
            diagramElement.setVisible(service.computeVisibility(mappingManager, diagram, diagramElement));
            if (!service.computeLabelVisibility(diagram, diagramElement)) {
                HideFilterHelper.INSTANCE.hideLabel(diagramElement);
            }
        }
    }
}

