/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.api.query;

import java.text.MessageFormat;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.Messages;
import org.eclipse.sirius.viewpoint.SiriusPlugin;

public class DRepresentationDescriptorQuery {
    private DRepresentationDescriptor repDescriptor;

    public DRepresentationDescriptorQuery(DRepresentationDescriptor repDescriptor) {
        this.repDescriptor = repDescriptor;
    }

    public boolean isDangling() {
        return this.repDescriptor.getTarget() == null || SessionManager.INSTANCE.getSession(this.repDescriptor.getTarget()) == null;
    }

    public boolean isRepresentationReachable() {
        boolean isRepresentationReachable = this.repDescriptor.isLoadedRepresentation();
        if (!isRepresentationReachable && this.repDescriptor.getRepPath() != null) {
            String extention = this.repDescriptor.getRepPath().getResourceURI().fileExtension();
            if ("aird".equals(extention)) {
                return isRepresentationReachable;
            }
            Resource eResource = this.repDescriptor.eResource();
            if (eResource != null) {
                ResourceSet resourceSet = eResource.getResourceSet();
                try {
                    isRepresentationReachable = resourceSet.getURIConverter().exists(this.repDescriptor.getRepPath().getResourceURI(), null);
                }
                catch (RuntimeException e) {
                    SiriusPlugin.getDefault().warning(MessageFormat.format(Messages.DRepresentationDescriptorQuery_representationError, this.repDescriptor.getName(), this.repDescriptor.getRepPath(), this.repDescriptor.getUid()), e);
                }
            }
        }
        return isRepresentationReachable;
    }

    public boolean isRepresentationValid() {
        return !this.isDangling() && this.isRepresentationReachable();
    }
}

