/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.ui.internal.handlers;

import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.IConfirmCallback;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.runtime.IFSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.core.model.ModelManager;
import org.eclipse.tcf.te.tcf.filesystem.ui.activator.UIPlugin;
import org.eclipse.tcf.te.tcf.filesystem.ui.internal.operations.UiExecutor;
import org.eclipse.tcf.te.tcf.filesystem.ui.nls.Messages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class DeleteHandler
extends AbstractHandler {
    private IConfirmCallback readonlyCallback = new ReadOnlyConfirmCallback();

    public Object execute(ExecutionEvent event) throws ExecutionException {
        List nodes;
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection && !selection.isEmpty() && this.confirmDeletion(nodes = ((IStructuredSelection)selection).toList())) {
            UiExecutor.execute(ModelManager.operationDelete((List)nodes, (IConfirmCallback)this.readonlyCallback));
        }
        return null;
    }

    private boolean confirmDeletion(List<IFSTreeNode> nodes) {
        String question;
        if (nodes.size() == 1) {
            IFSTreeNode node = nodes.get(0);
            question = NLS.bind((String)Messages.DeleteFilesHandler_DeleteOneFileConfirmation, (Object)node.getName());
        } else {
            question = NLS.bind((String)Messages.DeleteFilesHandler_DeleteMultipleFilesConfirmation, (Object)nodes.size());
        }
        Shell parent = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        return MessageDialog.openQuestion((Shell)parent, (String)Messages.DeleteFilesHandler_ConfirmDialogTitle, (String)question);
    }

    static class ReadOnlyConfirmCallback
    implements IConfirmCallback {
        ReadOnlyConfirmCallback() {
        }

        public boolean requires(Object object) {
            if (object instanceof IFSTreeNode) {
                IFSTreeNode node = (IFSTreeNode)object;
                return node.isWindowsNode() && node.isReadOnly() || !node.isWindowsNode() && !node.isWritable();
            }
            return false;
        }

        public int confirms(Object object) {
            final IFSTreeNode node = (IFSTreeNode)object;
            final int[] results = new int[1];
            Display display = PlatformUI.getWorkbench().getDisplay();
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    Shell parent = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                    String title = Messages.FSDelete_ConfirmDelete;
                    String message = NLS.bind((String)Messages.FSDelete_ConfirmMessage, (Object)node.getName());
                    final Image titleImage = UIPlugin.getImage("ConfirmReadOnlyDelete");
                    MessageDialog qDialog = new MessageDialog(parent, title, null, message, 3, new String[]{Messages.FSDelete_ButtonYes, Messages.FSDelete_ButtonYes2All, Messages.FSDelete_ButtonNo, Messages.FSDelete_ButtonCancel}, 0){

                        public Image getQuestionImage() {
                            return titleImage;
                        }
                    };
                    results[0] = qDialog.open();
                }
            });
            return results[0];
        }
    }
}

