/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.processes.ui.handler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.callback.Callback;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;
import org.eclipse.tcf.te.tcf.processes.core.model.interfaces.IProcessContextNode;
import org.eclipse.tcf.te.tcf.processes.core.model.steps.AttachStep;
import org.eclipse.ui.handlers.HandlerUtil;

public class AttachHandler
extends AbstractHandler {
    public Object execute(final ExecutionEvent event) throws ExecutionException {
        final ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    AttachHandler.this.execute(event, (IStructuredSelection)selection);
                }
            };
            Protocol.invokeLater((Runnable)runnable);
        }
        return null;
    }

    protected void execute(ExecutionEvent event, IStructuredSelection selection) {
        ArrayList<IProcessContextNode> nodes;
        IPeerNode peerNode;
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        Assert.isNotNull((Object)selection);
        HashMap contexts = new HashMap();
        for (Object candidate : selection) {
            IProcessContextNode node;
            if (!(candidate instanceof IProcessContextNode) || (peerNode = (IPeerNode)(node = (IProcessContextNode)candidate).getAdapter(IPeerNode.class)) == null) continue;
            nodes = (ArrayList<IProcessContextNode>)contexts.get(peerNode);
            if (nodes == null) {
                nodes = new ArrayList<IProcessContextNode>();
                contexts.put(peerNode, nodes);
            }
            if (nodes.contains(node)) continue;
            nodes.add(node);
        }
        if (!contexts.isEmpty()) {
            for (Map.Entry entry : contexts.entrySet()) {
                peerNode = (IPeerNode)entry.getKey();
                nodes = (List)entry.getValue();
                this.doAttach(event, peerNode, nodes.toArray(new IProcessContextNode[nodes.size()]));
            }
        }
    }

    protected void doAttach(ExecutionEvent event, IPeerNode peerNode, IProcessContextNode[] nodes) {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        Assert.isNotNull((Object)peerNode);
        Assert.isNotNull((Object)nodes);
        if (nodes.length > 0) {
            AttachStep step = new AttachStep();
            step.executeAttach(peerNode, nodes, (ICallback)new Callback());
        }
    }
}

