import { Protocol as Crdp } from 'devtools-protocol';
import { ITarget } from './chromeConnection';
import { IPathMapping } from '../debugAdapterInterfaces';
/**
 * Takes the path component of a target url (starting with '/') and applies pathMapping
 */
export declare function applyPathMappingsToTargetUrlPath(scriptUrlPath: string, pathMapping: IPathMapping): string;
export declare function applyPathMappingsToTargetUrl(scriptUrl: string, pathMapping: IPathMapping): string;
/**
 * Maps a url from target to an absolute local path, if it exists.
 * If not given an absolute path (with file: prefix), searches the current working directory for a matching file.
 * http://localhost/scripts/code.js => d:/app/scripts/code.js
 * file:///d:/scripts/code.js => d:/scripts/code.js
 */
export declare function targetUrlToClientPath(aUrl: string, pathMapping: IPathMapping): Promise<string>;
/**
 * Convert a RemoteObject to a value+variableHandleRef for the client.
 * TODO - Delete after Microsoft/vscode#12019!!
 */
export declare function remoteObjectToValue(object: Crdp.Runtime.RemoteObject, stringify?: boolean): {
    value: string;
    variableHandleRef?: string;
};
/**
 * Returns the targets from the given list that match the targetUrl, which may have * wildcards.
 * Ignores the protocol and is case-insensitive.
 */
export declare function getMatchingTargets(targets: ITarget[], targetUrlPattern: string): ITarget[];
export declare function compareVariableNames(var1: string, var2: string): number;
export declare function remoteObjectToCallArgument(object: Crdp.Runtime.RemoteObject): Crdp.Runtime.CallArgument;
/**
 * .exception is not present in Node < 6.6 - TODO this would be part of a generic solution for handling
 * protocol differences in the future.
 * This includes the error message and full stack
 */
export declare function descriptionFromExceptionDetails(exceptionDetails: Crdp.Runtime.ExceptionDetails): string;
/**
 * Get just the error message from the exception details - the first line without the full stack
 */
export declare function errorMessageFromExceptionDetails(exceptionDetails: Crdp.Runtime.ExceptionDetails): string;
export declare function getEvaluateName(parentEvaluateName: string, name: string): string;
export declare function selectBreakpointLocation(lineNumber: number, columnNumber: number, locations: Crdp.Debugger.BreakLocation[]): Crdp.Debugger.BreakLocation;
export declare const EVAL_NAME_PREFIX = "VM";
export declare function isEvalScript(scriptPath: string): boolean;
export declare function getUrlRegexForBreakOnLoad(url: string): string;
/**
 * Checks if a given tcp port is currently in use (more accurately, is there a server socket accepting connections on that port)
 * @param port The port to check
 * @param host Optional host, defaults to 127.0.0.1
 * @param timeout Timeout for the socket connect attempt
 * @returns True if a server socket is listening on the given port, false otherwise
 */
export declare function isPortInUse(port: number, host?: string, timeout?: number): Promise<boolean>;
/**
 * Get the port on which chrome was launched when passed "--remote-debugging-port=0"
 * @param userDataDir The profile data directory for the Chrome instance to check
 * @throws If reading the port failed for any reason
 */
export declare function getLaunchedPort(userDataDir: string): Promise<number>;
