/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.server.rename;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.FileNotFoundException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.lsp4j.InitializeResult;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.PrepareRenameParams;
import org.eclipse.lsp4j.PrepareRenameResult;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.RenameOptions;
import org.eclipse.lsp4j.RenameParams;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.util.Ranges;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.conversion.IValueConverterService;
import org.eclipse.xtext.ide.refactoring.IRenameStrategy2;
import org.eclipse.xtext.ide.refactoring.RefactoringIssueAcceptor;
import org.eclipse.xtext.ide.refactoring.RenameChange;
import org.eclipse.xtext.ide.refactoring.RenameContext;
import org.eclipse.xtext.ide.serializer.IChangeSerializer;
import org.eclipse.xtext.ide.server.Document;
import org.eclipse.xtext.ide.server.ILanguageServerAccess;
import org.eclipse.xtext.ide.server.rename.ChangeConverter2;
import org.eclipse.xtext.ide.server.rename.IRenameService2;
import org.eclipse.xtext.ide.server.rename.ServerRefactoringIssueAcceptor;
import org.eclipse.xtext.linking.impl.LinkingHelper;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.parsetree.reconstr.impl.TokenUtil;
import org.eclipse.xtext.resource.EObjectAtOffsetHelper;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.SimpleAttributeResolver;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.lib.Exceptions;

public class RenameService2
implements IRenameService2 {
    private static final Logger LOG = Logger.getLogger(RenameService2.class);
    @Inject
    private EObjectAtOffsetHelper eObjectAtOffsetHelper;
    @Inject
    private Provider<ServerRefactoringIssueAcceptor> issueProvider;
    @Inject
    private IResourceServiceProvider.Registry serviceProviderRegistry;
    @Inject
    private TokenUtil tokenUtil;
    @Inject
    private IValueConverterService valueConverterService;
    @Inject
    private LinkingHelper linkingHelper;
    private Function<EObject, String> attributeResolver = SimpleAttributeResolver.newResolver(String.class, (String)"name");

    @Override
    public WorkspaceEdit rename(IRenameService2.Options options) {
        try {
            TextDocumentIdentifier textDocument = options.getRenameParams().getTextDocument();
            String uri = textDocument.getUri();
            ServerRefactoringIssueAcceptor issueAcceptor = (ServerRefactoringIssueAcceptor)this.issueProvider.get();
            boolean shouldPrepareRename = this.shouldPrepareRename(options.getLanguageServerAccess());
            return (WorkspaceEdit)((CompletableFuture)options.getLanguageServerAccess().doRead(uri, context -> {
                if (shouldPrepareRename) {
                    CancelIndicator cancelIndicator;
                    Document document;
                    TextDocumentIdentifier identifier = new TextDocumentIdentifier(textDocument.getUri());
                    Position position = options.getRenameParams().getPosition();
                    PrepareRenameParams positionParams = new PrepareRenameParams(identifier, position);
                    Resource resource = context.getResource();
                    Either<Range, PrepareRenameResult> prepareRenameResult = this.doPrepareRename(resource, document = context.getDocument(), positionParams, cancelIndicator = options.getCancelIndicator());
                    if (!this.mayPerformRename(prepareRenameResult, options.getRenameParams())) {
                        return null;
                    }
                }
                WorkspaceEdit workspaceEdit = new WorkspaceEdit();
                ResourceSet resourceSet = options.getLanguageServerAccess().newLiveScopeResourceSet(context.getResource().getURI());
                Resource xtextResource = resourceSet.getResource(context.getResource().getURI(), true);
                if (xtextResource instanceof XtextResource) {
                    Position position = options.getRenameParams().getPosition();
                    EObject element = null;
                    try {
                        element = this.getElementAtOffset((XtextResource)xtextResource, context.getDocument(), position);
                    }
                    catch (IndexOutOfBoundsException e) {
                        issueAcceptor.add(RefactoringIssueAcceptor.Severity.FATAL, "Invalid document " + this.toPositionFragment(position, uri), new Object[0]);
                    }
                    if (element == null || element.eIsProxy()) {
                        issueAcceptor.add(RefactoringIssueAcceptor.Severity.FATAL, "No element found at " + this.toPositionFragment(position, uri), new Object[0]);
                    } else {
                        IResourceServiceProvider services = this.serviceProviderRegistry.getResourceServiceProvider(element.eResource().getURI());
                        IChangeSerializer changeSerializer = (IChangeSerializer)services.get(IChangeSerializer.class);
                        RenameChange change = new RenameChange(options.getRenameParams().getNewName(), EcoreUtil.getURI((EObject)element));
                        RenameContext renameContext = new RenameContext(Lists.newArrayList((Object[])new RenameChange[]{change}), resourceSet, changeSerializer, issueAcceptor);
                        IRenameStrategy2 renameStrategy = (IRenameStrategy2)services.get(IRenameStrategy2.class);
                        renameStrategy.applyRename(renameContext);
                        ChangeConverter2.Factory converterFactory = (ChangeConverter2.Factory)services.get(ChangeConverter2.Factory.class);
                        ChangeConverter2 changeConverter = converterFactory.create(workspaceEdit, options.getLanguageServerAccess());
                        changeSerializer.applyModifications(changeConverter);
                    }
                } else {
                    issueAcceptor.add(RefactoringIssueAcceptor.Severity.FATAL, "Loaded resource is not an XtextResource", context.getResource().getURI());
                }
                issueAcceptor.checkSeverity();
                return workspaceEdit;
            }).exceptionally(exception -> {
                try {
                    Throwable rootCause = Throwables.getRootCause((Throwable)exception);
                    if (rootCause instanceof FileNotFoundException && shouldPrepareRename) {
                        return null;
                    }
                    throw exception;
                }
                catch (Throwable e) {
                    throw Exceptions.sneakyThrow((Throwable)e);
                }
            })).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw Exceptions.sneakyThrow((Throwable)e);
        }
    }

    protected EObject getElementAtOffset(XtextResource xtextResource, Document document, Position caretPosition) {
        int caretOffset = document.getOffSet(caretPosition);
        EObject element = this.getElementWithIdentifierAt(xtextResource, caretOffset);
        if (element != null) {
            return element;
        }
        return this.getElementWithIdentifierAt(xtextResource, caretOffset - 1);
    }

    protected EObject getElementWithIdentifierAt(XtextResource xtextResource, int offset) {
        ILeafNode leaf;
        ICompositeNode rootNode;
        IParseResult parseResult;
        if (offset >= 0 && xtextResource != null && (parseResult = xtextResource.getParseResult()) != null && (rootNode = parseResult.getRootNode()) != null && (leaf = NodeModelUtils.findLeafNodeAtOffset((INode)rootNode, (int)offset)) != null && this.isIdentifier(leaf)) {
            return this.eObjectAtOffsetHelper.resolveElementAt(xtextResource, offset);
        }
        return null;
    }

    protected boolean isIdentifier(ILeafNode leafNode) {
        return (leafNode.getGrammarElement() instanceof RuleCall || leafNode.getGrammarElement() instanceof CrossReference) && !this.tokenUtil.isWhitespaceOrCommentNode((INode)leafNode);
    }

    @Override
    public Either<Range, PrepareRenameResult> prepareRename(IRenameService2.PrepareRenameOptions options) {
        try {
            String uri = options.getParams().getTextDocument().getUri();
            boolean shouldPrepareRename = this.shouldPrepareRename(options.getLanguageServerAccess());
            return (Either)((CompletableFuture)options.getLanguageServerAccess().doRead(uri, context -> {
                if (!shouldPrepareRename) {
                    return null;
                }
                Resource resource = context.getResource();
                Document document = context.getDocument();
                PrepareRenameParams params = options.getParams();
                CancelIndicator cancelIndicator = options.getCancelIndicator();
                return this.doPrepareRename(resource, document, params, cancelIndicator);
            }).exceptionally(exception -> {
                try {
                    Throwable rootCause = Throwables.getRootCause((Throwable)exception);
                    if (rootCause instanceof FileNotFoundException && shouldPrepareRename) {
                        return null;
                    }
                    throw exception;
                }
                catch (Throwable e) {
                    throw Exceptions.sneakyThrow((Throwable)e);
                }
            })).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw Exceptions.sneakyThrow((Throwable)e);
        }
    }

    protected Either<Range, PrepareRenameResult> doPrepareRename(Resource resource, Document document, PrepareRenameParams params, CancelIndicator cancelIndicator) {
        String uri = params.getTextDocument().getUri();
        if (resource instanceof XtextResource) {
            IParseResult parseResult;
            ICompositeNode rootNode = null;
            XtextResource xtextResource = (XtextResource)resource;
            if (xtextResource != null && (parseResult = xtextResource.getParseResult()) != null) {
                rootNode = parseResult.getRootNode();
            }
            if (rootNode == null) {
                LOG.trace((Object)("Could not retrieve root node for resource. URI: " + uri));
                return null;
            }
            Position caretPosition = params.getPosition();
            try {
                int caretOffset = document.getOffSet(caretPosition);
                EObject element = null;
                int candidateOffset = caretOffset;
                do {
                    ILeafNode leaf;
                    if ((element = this.getElementWithIdentifierAt(xtextResource, candidateOffset)) == null || element.eIsProxy() || (leaf = NodeModelUtils.findLeafNodeAtOffset((INode)rootNode, (int)candidateOffset)) == null || !this.isIdentifier(leaf)) continue;
                    String convertedNameValue = this.getConvertedValue(leaf.getGrammarElement(), leaf);
                    String elementName = this.getElementName(element);
                    if (Strings.isEmpty((String)convertedNameValue) || Strings.isEmpty((String)elementName) || !Objects.equal((Object)convertedNameValue, (Object)elementName)) continue;
                    Position start = document.getPosition(leaf.getOffset());
                    Position end = document.getPosition(leaf.getEndOffset());
                    return Either.forLeft((Object)new Range(start, end));
                } while (--candidateOffset >= 0 && candidateOffset + 1 >= caretOffset);
            }
            catch (IndexOutOfBoundsException e) {
                LOG.trace((Object)("Invalid document " + this.toPositionFragment(caretPosition, uri)));
                return null;
            }
            LOG.trace((Object)("No element found at " + this.toPositionFragment(caretPosition, uri)));
        } else {
            LOG.trace((Object)("Loaded resource is not an XtextResource. URI: " + resource.getURI()));
        }
        return null;
    }

    protected String getConvertedValue(EObject grammarElement, ILeafNode leaf) {
        try {
            if (grammarElement instanceof RuleCall) {
                return this.valueConverterService.toValue(leaf.getText(), ((RuleCall)grammarElement).getRule().getName(), (INode)leaf).toString();
            }
            if (grammarElement instanceof CrossReference) {
                return this.linkingHelper.getCrossRefNodeAsString((INode)leaf, true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return leaf.getText();
    }

    protected boolean mayPerformRename(Either<Range, PrepareRenameResult> prepareRenameResult, RenameParams renameParams) {
        return prepareRenameResult != null && prepareRenameResult.getLeft() != null && Ranges.containsPosition((Range)((Range)prepareRenameResult.getLeft()), (Position)renameParams.getPosition());
    }

    protected String getElementName(EObject element) {
        if (element == null) {
            return null;
        }
        String name = (String)this.attributeResolver.apply((Object)element);
        if (Strings.isEmpty((String)name)) {
            return null;
        }
        return name;
    }

    private String toPositionFragment(Position it, String uri) {
        return "position line: " + it.getLine() + " column: " + it.getCharacter() + " in resource: " + uri;
    }

    private boolean shouldPrepareRename(ILanguageServerAccess access) {
        ServerCapabilities capabilities;
        InitializeResult initializeResult;
        Either provider = null;
        if (access != null && (initializeResult = access.getInitializeResult()) != null && (capabilities = initializeResult.getCapabilities()) != null) {
            provider = capabilities.getRenameProvider();
        }
        if (provider != null && provider.isRight()) {
            return Boolean.TRUE.equals(((RenameOptions)provider.getRight()).getPrepareProvider());
        }
        return false;
    }

    protected EObjectAtOffsetHelper getEObjectAtOffsetHelper() {
        return this.eObjectAtOffsetHelper;
    }

    protected Provider<ServerRefactoringIssueAcceptor> getIssueProvider() {
        return this.issueProvider;
    }

    protected IResourceServiceProvider.Registry getServiceProviderRegistry() {
        return this.serviceProviderRegistry;
    }

    protected TokenUtil getTokenUtil() {
        return this.tokenUtil;
    }

    protected IValueConverterService getValueConverterService() {
        return this.valueConverterService;
    }

    protected LinkingHelper getLinkingHelper() {
        return this.linkingHelper;
    }

    protected Function<EObject, String> getAttributeResolver() {
        return this.attributeResolver;
    }
}

