/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.nodemodel.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.impl.RootNode;
import org.eclipse.xtext.util.LineAndColumn;

public class InternalNodeModelUtils {
    protected InternalNodeModelUtils() {
        throw new AssertionError();
    }

    protected static LineAndColumn getLineAndColumn(INode anyNode, int documentOffset) {
        ICompositeNode rootNode = anyNode.getRootNode();
        int[] lineBreaks = InternalNodeModelUtils.getLineBreakOffsets(rootNode);
        String document = rootNode.getText();
        return InternalNodeModelUtils.getLineAndColumn(document, lineBreaks, documentOffset);
    }

    protected static LineAndColumn getLineAndColumn(String text, int[] lineBreaks, int offset) {
        Preconditions.checkPositionIndex((int)offset, (int)text.length());
        int idx = Arrays.binarySearch(lineBreaks, offset);
        if (idx >= 0) {
            return InternalNodeModelUtils.getLineAndColumnOfLineBreak(text, lineBreaks, idx, offset);
        }
        int insertionPoint = -(idx + 1);
        return InternalNodeModelUtils.getLineAndColumnNoExactLineBreak(text, lineBreaks, insertionPoint, offset);
    }

    private static LineAndColumn getLineAndColumnNoExactLineBreak(String text, int[] lineBreaks, int insertionPoint, int offset) {
        int column;
        int line;
        if (insertionPoint == 0) {
            line = 1;
            column = offset + 1;
        } else {
            int lineBreakIdx = insertionPoint - 1;
            int leftLineBreak = lineBreaks[lineBreakIdx];
            if (leftLineBreak + 1 == offset) {
                if (text.charAt(leftLineBreak) == '\r' && text.charAt(offset) == '\n') {
                    int prevLineBreak;
                    line = insertionPoint;
                    column = lineBreakIdx > 0 ? (text.charAt(prevLineBreak = lineBreaks[lineBreakIdx - 1]) == '\r' && text.charAt(prevLineBreak + 1) == '\n' ? offset - prevLineBreak - 1 : offset - prevLineBreak) : offset + 1;
                } else {
                    line = insertionPoint + 1;
                    column = offset - leftLineBreak;
                }
            } else {
                line = insertionPoint + 1;
                column = text.charAt(leftLineBreak) == '\r' && text.charAt(leftLineBreak + 1) == '\n' ? offset - leftLineBreak - 1 : offset - leftLineBreak;
            }
        }
        return LineAndColumn.from((int)line, (int)column);
    }

    private static LineAndColumn getLineAndColumnOfLineBreak(String text, int[] lineBreaks, int lineBreakIdx, int offset) {
        int lineBreak;
        int prevLineBreak;
        int line = lineBreakIdx + 1;
        int column = lineBreakIdx == 0 ? offset + 1 : ((prevLineBreak = lineBreaks[lineBreakIdx - 1]) < (lineBreak = lineBreaks[lineBreakIdx]) - 1 && text.charAt(prevLineBreak) == '\r' && text.charAt(prevLineBreak + 1) == '\n' ? lineBreak - prevLineBreak - 1 : lineBreak - prevLineBreak);
        return LineAndColumn.from((int)line, (int)column);
    }

    private static int[] getLineBreakOffsets(INode rootNode) {
        if (rootNode instanceof RootNode) {
            return ((RootNode)rootNode).basicGetLineBreakOffsets();
        }
        String text = rootNode.getText();
        return InternalNodeModelUtils.computeLineBreaks(text);
    }

    protected static int[] computeLineBreaks(String text) {
        ArrayList list = Lists.newArrayListWithExpectedSize((int)(text.length() / 20 + 1));
        int length = text.length();
        for (int i = 0; i < length; ++i) {
            char ch = text.charAt(i);
            if (ch == '\r') {
                list.add(i);
                if (i + 1 >= length || text.charAt(i + 1) != '\n') continue;
                ++i;
                continue;
            }
            if (ch != '\n') continue;
            list.add(i);
        }
        int[] result = new int[list.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (Integer)list.get(i);
        }
        return result;
    }
}

