/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages;

import java.util.Objects;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.RegistryAuth;

final class ImmutableRegistryAuth
implements RegistryAuth {
    @Nullable
    private final String username;
    @Nullable
    private final String password;
    @Nullable
    private final String email;
    @Nullable
    private final String serverAddress;
    @Nullable
    private final String identityToken;
    private final transient RegistryAuth.Builder toBuilder;

    private ImmutableRegistryAuth(@Nullable String username, @Nullable String password, @Nullable String email, @Nullable String serverAddress, @Nullable String identityToken) {
        this.username = username;
        this.password = password;
        this.email = email;
        this.serverAddress = serverAddress;
        this.identityToken = identityToken;
        this.toBuilder = Objects.requireNonNull(RegistryAuth.super.toBuilder(), "toBuilder");
    }

    @Override
    @Nullable
    public String username() {
        return this.username;
    }

    @Override
    @Nullable
    public String password() {
        return this.password;
    }

    @Override
    @Nullable
    public String email() {
        return this.email;
    }

    @Override
    @Nullable
    public String serverAddress() {
        return this.serverAddress;
    }

    @Override
    @Nullable
    public String identityToken() {
        return this.identityToken;
    }

    @Override
    public RegistryAuth.Builder toBuilder() {
        return this.toBuilder;
    }

    public final ImmutableRegistryAuth withUsername(@Nullable String value) {
        if (Objects.equals(this.username, value)) {
            return this;
        }
        return new ImmutableRegistryAuth(value, this.password, this.email, this.serverAddress, this.identityToken);
    }

    public final ImmutableRegistryAuth withPassword(@Nullable String value) {
        if (Objects.equals(this.password, value)) {
            return this;
        }
        return new ImmutableRegistryAuth(this.username, value, this.email, this.serverAddress, this.identityToken);
    }

    public final ImmutableRegistryAuth withEmail(@Nullable String value) {
        if (Objects.equals(this.email, value)) {
            return this;
        }
        return new ImmutableRegistryAuth(this.username, this.password, value, this.serverAddress, this.identityToken);
    }

    public final ImmutableRegistryAuth withServerAddress(@Nullable String value) {
        if (Objects.equals(this.serverAddress, value)) {
            return this;
        }
        return new ImmutableRegistryAuth(this.username, this.password, this.email, value, this.identityToken);
    }

    public final ImmutableRegistryAuth withIdentityToken(@Nullable String value) {
        if (Objects.equals(this.identityToken, value)) {
            return this;
        }
        return new ImmutableRegistryAuth(this.username, this.password, this.email, this.serverAddress, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRegistryAuth && this.equalTo((ImmutableRegistryAuth)another);
    }

    private boolean equalTo(ImmutableRegistryAuth another) {
        return Objects.equals(this.username, another.username) && Objects.equals(this.password, another.password) && Objects.equals(this.email, another.email) && Objects.equals(this.serverAddress, another.serverAddress) && Objects.equals(this.identityToken, another.identityToken);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.username);
        h += (h << 5) + Objects.hashCode(this.password);
        h += (h << 5) + Objects.hashCode(this.email);
        h += (h << 5) + Objects.hashCode(this.serverAddress);
        h += (h << 5) + Objects.hashCode(this.identityToken);
        return h;
    }

    public String toString() {
        return "RegistryAuth{username=" + this.username + ", serverAddress=" + this.serverAddress + ", identityToken=" + this.identityToken + "}";
    }

    public static ImmutableRegistryAuth copyOf(RegistryAuth instance) {
        if (instance instanceof ImmutableRegistryAuth) {
            return (ImmutableRegistryAuth)instance;
        }
        return ImmutableRegistryAuth.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    static final class Builder
    implements RegistryAuth.Builder {
        private String username;
        private String password;
        private String email;
        private String serverAddress;
        private String identityToken;

        private Builder() {
        }

        public final Builder from(RegistryAuth instance) {
            String identityTokenValue;
            String serverAddressValue;
            String emailValue;
            String passwordValue;
            Objects.requireNonNull(instance, "instance");
            String usernameValue = instance.username();
            if (usernameValue != null) {
                this.username(usernameValue);
            }
            if ((passwordValue = instance.password()) != null) {
                this.password(passwordValue);
            }
            if ((emailValue = instance.email()) != null) {
                this.email(emailValue);
            }
            if ((serverAddressValue = instance.serverAddress()) != null) {
                this.serverAddress(serverAddressValue);
            }
            if ((identityTokenValue = instance.identityToken()) != null) {
                this.identityToken(identityTokenValue);
            }
            return this;
        }

        @Override
        public final Builder username(@Nullable String username) {
            this.username = username;
            return this;
        }

        @Override
        public final Builder password(@Nullable String password) {
            this.password = password;
            return this;
        }

        @Override
        public final Builder email(@Nullable String email) {
            this.email = email;
            return this;
        }

        @Override
        public final Builder serverAddress(@Nullable String serverAddress) {
            this.serverAddress = serverAddress;
            return this;
        }

        @Override
        public final Builder identityToken(@Nullable String identityToken) {
            this.identityToken = identityToken;
            return this;
        }

        @Override
        public ImmutableRegistryAuth build() {
            return new ImmutableRegistryAuth(this.username, this.password, this.email, this.serverAddress, this.identityToken);
        }
    }
}

