/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.sqm.server.internal.ui.util;

import com.ibm.icu.util.StringTokenizer;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.sqm.core.connection.ConnectionInfo;
import org.eclipse.datatools.connectivity.sqm.core.containment.ContainmentService;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.services.IElementIDProvider;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.connectivity.sqm.internal.core.util.ConnectionUtil;
import org.eclipse.datatools.connectivity.sqm.server.internal.ui.explorer.providers.ServerExplorerManager;
import org.eclipse.datatools.connectivity.sqm.server.internal.ui.services.IServerExplorerNodeResolutionService;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;

public class TransientEObjectUtil
implements IElementIDProvider {
    private static final ContainmentService containment = RDBCorePlugin.getDefault().getContainmentService();
    private static final String SEPARATOR = "#";
    private static final String VIRTUAL_SEPARATOR = "/";
    private static final String NULL = "";
    private static final Stack stack = new Stack();

    private static EObject getRoot(EObject object) {
        stack.push(object);
        do {
            EObject parent = null;
            parent = containment.getContainer(object);
            if (parent == null) {
                return object;
            }
            object = parent;
            stack.push(object);
        } while (object != null);
        return object;
    }

    public static ConnectionInfo getConnectionInfo(EObject object) {
        SQLObject root = (SQLObject)TransientEObjectUtil.getRoot(object);
        if (root != null) {
            return ConnectionUtil.getConnectionForEObject((EObject)root);
        }
        return null;
    }

    private static IConnectionProfile getConnectionProfile(EObject object) throws Exception {
        ConnectionInfo info = TransientEObjectUtil.getConnectionInfo(object);
        return info != null ? info.getConnectionProfile() : null;
    }

    private static void buildID(StringBuffer buffer, String name) {
        buffer.append(String.valueOf(name) + SEPARATOR);
    }

    private static void buildID(StringBuffer buffer) {
        while (!stack.empty()) {
            ENamedElement eObject = (ENamedElement)stack.pop();
            String groupID = containment.getGroupId((EObject)eObject);
            buffer.append(String.valueOf(groupID) + VIRTUAL_SEPARATOR + eObject.getName() + SEPARATOR);
        }
    }

    public static String getEObjectId(EObject object) throws Exception {
        StringBuffer buffer = new StringBuffer();
        stack.clear();
        IConnectionProfile profile = TransientEObjectUtil.getConnectionProfile(object);
        if (profile != null) {
            TransientEObjectUtil.buildID(buffer, profile.getName());
            TransientEObjectUtil.buildID(buffer);
        }
        stack.clear();
        return buffer.toString();
    }

    public static List getPathFromID(String id) {
        StringTokenizer tokens = new StringTokenizer(id, SEPARATOR);
        ArrayList<String> list = new ArrayList<String>();
        while (tokens.hasMoreElements()) {
            list.add(tokens.nextToken());
        }
        return list;
    }

    public static IGroup getGroupInfo(final String subId) {
        return new IGroup(){

            @Override
            public String getGroupId() {
                return subId.substring(0, subId.indexOf(TransientEObjectUtil.VIRTUAL_SEPARATOR));
            }

            @Override
            public String getElementName() {
                String elementName = subId.substring(subId.indexOf(TransientEObjectUtil.VIRTUAL_SEPARATOR) + 1);
                return elementName.equals(TransientEObjectUtil.NULL) ? null : elementName;
            }
        };
    }

    public static EObject getEObjectFromId(String id) {
        EObject obj = null;
        IServerExplorerNodeResolutionService service = ServerExplorerManager.INSTANCE.getServerExplorerNodeResolutionService();
        obj = service.getEObjectNode(id);
        return obj;
    }

    public String getElementID(EObject eObject) {
        try {
            return eObject instanceof ICatalogObject ? TransientEObjectUtil.getEObjectId(eObject) : null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static interface IGroup {
        public String getGroupId();

        public String getElementName();
    }
}

