/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.ui.status;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.datatools.connectivity.IConnection;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IManagedConnection;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.datatools.connectivity.ui.status.DatatoolsStatus;
import org.eclipse.ui.statushandlers.StatusManager;

public class DatatoolsStatusListener
extends JobChangeAdapter {
    private IConnectionProfile profile;

    public DatatoolsStatusListener(IConnectionProfile profile) {
        this.profile = profile;
    }

    public void done(IJobChangeEvent event) {
        IManagedConnection managedConnection = this.profile.getManagedConnection("org.eclipse.datatools.connectivity.sqm.core.connection.ConnectionInfo");
        if (managedConnection != null) {
            IConnection internalConnection = managedConnection.getConnection();
            if (internalConnection == null || internalConnection.getConnectException() == null) {
                return;
            }
            DatatoolsStatus datatoolsStatus = new DatatoolsStatus(4, ConnectivityUIPlugin.getDefault().getBundle().getSymbolicName(), internalConnection.getConnectException(), this.profile, internalConnection);
            datatoolsStatus.setName("org.eclipse.datatools.connection.status");
            StatusManager.getManager().handle((IStatus)datatoolsStatus, 7);
        }
    }
}

