/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.explorer.ui.checkouts;

import org.eclipse.emf.cdo.CDOElement;
import org.eclipse.emf.cdo.common.util.CDOCommonUtil;
import org.eclipse.emf.cdo.explorer.checkouts.CDOCheckout;
import org.eclipse.emf.cdo.explorer.ui.BaseLabelDecorator;
import org.eclipse.emf.cdo.explorer.ui.bundle.OM;
import org.eclipse.emf.cdo.ui.CDOLabelDecorator;
import org.eclipse.net4j.util.AdapterUtil;
import org.eclipse.net4j.util.lifecycle.LifecycleException;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.swt.graphics.Image;

public class CDOCheckoutLabelDecorator
extends BaseLabelDecorator {
    @Override
    public Image decorateImage(Image image, Object element) {
        block5: {
            try {
                CDOElement cdoElement = (CDOElement)AdapterUtil.adapt((Object)element, CDOElement.class);
                if (cdoElement != null) {
                    element = cdoElement.getDelegate();
                }
                if (element instanceof CDOCheckout) {
                    image = CDOLabelDecorator.decorate((Image)image, (Object)element);
                }
            }
            catch (LifecycleException cdoElement) {
            }
            catch (Throwable ex) {
                if (!LifecycleUtil.isActive((Object)element)) break block5;
                OM.LOG.error(ex);
            }
        }
        return image;
    }

    @Override
    public String decorateText(String text, Object element) {
        block15: {
            try {
                CDOElement cdoElement = (CDOElement)AdapterUtil.adapt((Object)element, CDOElement.class);
                if (cdoElement != null) {
                    element = cdoElement.getDelegate();
                }
                if (element instanceof CDOCheckout) {
                    long timeStamp;
                    CDOCheckout checkout = (CDOCheckout)element;
                    String branchPath = checkout.getBranchPath();
                    if (branchPath != null) {
                        if (branchPath.startsWith("MAIN")) {
                            branchPath = branchPath.substring("MAIN".length());
                        }
                        if (branchPath.startsWith("/")) {
                            branchPath = branchPath.substring("/".length());
                        }
                        if (branchPath.length() != 0) {
                            text = checkout.isOffline() ? String.valueOf(text) + "  [offline: " + branchPath + "]" : String.valueOf(text) + "  [" + branchPath + "]";
                        } else if (checkout.isOffline()) {
                            text = String.valueOf(text) + "  [offline]";
                        }
                    }
                    if ((timeStamp = checkout.getTimeStamp()) != 0L) {
                        text = String.valueOf(text) + "  " + CDOCommonUtil.formatTimeStamp((long)timeStamp);
                    } else if (checkout.isReadOnly()) {
                        text = String.valueOf(text) + "  read-only";
                    }
                    if (checkout.isOffline()) {
                        text = checkout.isDirty() ? String.valueOf(text) + "  dirty" : String.valueOf(text) + "  clean";
                    }
                }
            }
            catch (LifecycleException cdoElement) {
            }
            catch (Throwable ex) {
                if (!LifecycleUtil.isActive((Object)element)) break block15;
                OM.LOG.error(ex);
            }
        }
        return text;
    }
}

