/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.fx.swt.controls;

import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.embed.swt.FXCanvas;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class FXColorPicker
extends Composite {
    public static final String COLOR_PROPERTY = "color";
    private ObjectProperty<Color> color = new SimpleObjectProperty((Object)this, "color");
    private Rectangle colorRectangle;

    protected static Color pickColor(Shell shell, Color initial) {
        ColorDialog cd = new ColorDialog(shell);
        RGB rgb = new RGB((int)(255.0 * initial.getRed()), (int)(255.0 * initial.getGreen()), (int)(255.0 * initial.getBlue()));
        cd.setRGB(rgb);
        RGB newRgb = cd.open();
        if (newRgb != null) {
            return Color.rgb((int)newRgb.red, (int)newRgb.green, (int)newRgb.blue);
        }
        return null;
    }

    public FXColorPicker(Composite parent, Color color) {
        super(parent, 0);
        this.setLayout((Layout)new FillLayout());
        FXCanvas canvas = new FXCanvas((Composite)this, 0);
        Group colorPickerGroup = new Group();
        HBox hbox = new HBox();
        colorPickerGroup.getChildren().add((Object)hbox);
        WritableImage colorWheelImage = new WritableImage(64, 64);
        this.renderColorWheel(colorWheelImage, 0, 0, 64);
        ImageView colorWheel = new ImageView((Image)colorWheelImage);
        colorWheel.setFitWidth(16.0);
        colorWheel.setFitHeight(16.0);
        BorderPane colorWheelPane = new BorderPane();
        Insets insets = new Insets(2.0);
        colorWheelPane.setPadding(insets);
        colorWheelPane.setCenter((Node)colorWheel);
        colorWheelPane.setStyle("-fx-background-color: " + this.computeRgbString(Color.rgb((int)parent.getBackground().getRed(), (int)parent.getBackground().getGreen(), (int)parent.getBackground().getBlue())));
        this.colorRectangle = new Rectangle(50.0, 20.0);
        this.colorRectangle.widthProperty().bind((ObservableValue)colorWheel.fitWidthProperty().add(insets.getLeft()).add(insets.getRight()).multiply(2.5));
        this.colorRectangle.heightProperty().bind((ObservableValue)colorWheelPane.heightProperty());
        hbox.setStyle("-fx-border-color: " + this.computeRgbString(Color.DARKGREY) + "; -fx-background-color: " + this.computeRgbString(Color.DARKGREY));
        hbox.getChildren().addAll((Object[])new Node[]{this.colorRectangle, colorWheelPane});
        hbox.setSpacing(0.5);
        colorWheelPane.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                Color colorOrNull = FXColorPicker.pickColor(FXColorPicker.this.getShell(), FXColorPicker.this.getColor());
                if (colorOrNull != null) {
                    FXColorPicker.this.setColor(colorOrNull);
                }
            }
        });
        Scene scene = new Scene((Parent)colorPickerGroup);
        org.eclipse.swt.graphics.Color backgroundColor = parent.getBackground();
        scene.setFill((Paint)Color.rgb((int)backgroundColor.getRed(), (int)backgroundColor.getGreen(), (int)backgroundColor.getBlue()));
        canvas.setScene(scene);
        this.setColor(color);
        this.colorRectangle.fillProperty().bind(this.color);
    }

    public Property<Color> colorProperty() {
        return this.color;
    }

    private String computeRgbString(Color color) {
        return "rgb(" + (int)(255.0 * color.getRed()) + "," + (int)(255.0 * color.getGreen()) + "," + (int)(255.0 * color.getBlue()) + ")";
    }

    public Color getColor() {
        return (Color)this.color.get();
    }

    private void renderColorWheel(WritableImage image, int offsetX, int offsetY, int size) {
        PixelWriter px = image.getPixelWriter();
        double radius = size / 2;
        Point2D mid = new Point2D(radius, radius);
        int y = 0;
        while (y < size) {
            int x = 0;
            while (x < size) {
                double d = mid.distance((double)x, (double)y);
                if (d <= radius) {
                    double angleRad = d == 0.0 ? 0.0 : Math.atan2((double)y - mid.getY(), (double)x - mid.getX());
                    double sat = d / radius;
                    Color color = Color.hsb((double)(angleRad * 180.0 / Math.PI), (double)sat, (double)1.0);
                    px.setColor(offsetX + x, offsetY + y, color);
                } else {
                    px.setColor(offsetX + x, offsetY + y, Color.TRANSPARENT);
                }
                ++x;
            }
            ++y;
        }
    }

    public void setColor(Color color) {
        this.color.set((Object)color);
    }
}

