/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.jubula.client.core.model.IDataSetPO;
import org.eclipse.jubula.client.core.model.IParamDescriptionPO;
import org.eclipse.jubula.client.core.model.IParameterInterfacePO;
import org.eclipse.jubula.client.core.utils.FunctionToken;
import org.eclipse.jubula.client.core.utils.IParamValueToken;
import org.eclipse.jubula.client.core.utils.NullValidator;
import org.eclipse.jubula.client.core.utils.ParamValueConverter;
import org.eclipse.jubula.client.core.utils.RefToken;
import org.eclipse.jubula.client.core.utils.SimpleValueToken;
import org.eclipse.jubula.client.core.utils.TokenError;

public class ModelParamValueConverter
extends ParamValueConverter {
    public ModelParamValueConverter(String modelString, IParameterInterfacePO currentNode, IParamDescriptionPO desc) {
        super(currentNode, desc, new NullValidator());
        this.setModelString(modelString);
        this.createTokens();
    }

    @Override
    public String getGuiString() {
        if (super.getGuiString() == null) {
            StringBuilder builder = new StringBuilder();
            for (IParamValueToken token : this.getTokens()) {
                builder.append(token.getGuiString());
            }
            if (builder.length() > 0) {
                this.setGuiString(builder.toString());
            } else {
                return this.getModelString();
            }
        }
        return super.getGuiString();
    }

    @Override
    void validateSingleTokens() {
        for (IParamValueToken token : this.getTokens()) {
            ParamValueConverter.ConvValidationState state = token.validate();
            if (state != ParamValueConverter.ConvValidationState.invalid && state != ParamValueConverter.ConvValidationState.undecided) continue;
            TokenError tokenError = new TokenError(this.getModelString(), token.getErrorKey(), state);
            this.addError(tokenError);
        }
    }

    public boolean removeReference(String guid) {
        boolean isRefRemoved = false;
        ArrayList<IParamValueToken> tokensCopy = new ArrayList<IParamValueToken>(this.getAllTokens());
        for (IParamValueToken token : tokensCopy) {
            RefToken refToken;
            String refGuid;
            if (!(token instanceof RefToken) || !(refGuid = RefToken.extractCore((refToken = (RefToken)token).getModelString())).equals(guid)) continue;
            this.getTokens();
            for (IParamValueToken iParamValueToken : tokensCopy) {
                if (!(iParamValueToken instanceof FunctionToken)) continue;
                this.removeTokenFromFunction((FunctionToken)iParamValueToken, token);
            }
            this.getTokens().remove(token);
            isRefRemoved = true;
        }
        if (isRefRemoved) {
            this.updateStrings();
        }
        return isRefRemoved;
    }

    private void removeTokenFromFunction(FunctionToken ftoken, IParamValueToken tokenToDelete) {
        IParamValueToken[] nestedTokens = ftoken.getNestedTokens();
        int i = 0;
        while (i < nestedTokens.length) {
            IParamValueToken valueToken = nestedTokens[i];
            if (valueToken instanceof FunctionToken) {
                this.removeTokenFromFunction((FunctionToken)valueToken, tokenToDelete);
            }
            if (valueToken.equals(tokenToDelete)) {
                nestedTokens[i] = new SimpleValueToken("DELETED", i, ftoken.getParamDescription());
            }
            ++i;
        }
    }

    public boolean replaceUuidsInReferences(Map<String, String> map) {
        boolean isModified = false;
        List<RefToken> refTokens = this.getRefTokens();
        for (RefToken refToken : refTokens) {
            String oldGuid = RefToken.extractCore(refToken.getModelString());
            if (!map.containsKey(oldGuid)) continue;
            String newGuid = map.get(oldGuid);
            refToken.setModelString(RefToken.replaceCore(newGuid, refToken.getModelString()));
            isModified = true;
        }
        if (isModified) {
            this.updateModelString();
        }
        return isModified;
    }

    private void updateModelString() {
        StringBuilder builder = new StringBuilder();
        String oldModelString = this.getModelString();
        for (IParamValueToken token : this.getTokens()) {
            builder.append(token.getModelString());
        }
        this.setModelString(builder.toString());
        for (IDataSetPO dataSet : this.getCurrentNode().getDataManager().getDataSets()) {
            int i = 0;
            while (i < dataSet.getColumnCount()) {
                String data = dataSet.getValueAt(i);
                if (data != null && data.equals(oldModelString)) {
                    dataSet.setValueAt(i, this.getModelString());
                    return;
                }
                ++i;
            }
        }
    }

    private void updateStrings() {
        this.updateModelString();
        this.setGuiString(null);
    }

    @Override
    public boolean isGUI() {
        return false;
    }
}

