/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers.delete;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jubula.client.core.businessprocess.db.NodeBP;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.persistence.MultipleNodePM;
import org.eclipse.jubula.client.core.persistence.NodePM;
import org.eclipse.jubula.client.ui.rcp.handlers.delete.AbstractDeleteTreeItemHandler;
import org.eclipse.jubula.client.ui.rcp.handlers.delete.DeleteNodesTransaction;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.utils.ErrorHandlingUtil;
import org.eclipse.jubula.tools.internal.messagehandling.MessageIDs;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class DeleteTCTSBrowserTreeItemHandler
extends AbstractDeleteTreeItemHandler {
    public Object executeImpl(ExecutionEvent event) {
        IStructuredSelection structuredSelection = this.getSelection();
        if (this.confirmDelete(structuredSelection)) {
            this.deleteSelection(structuredSelection);
        }
        return null;
    }

    private static Object[] createLocOfUseArray(ISpecTestCasePO specTcPO, List<IExecTestCasePO> reusesSet, Collection<INodePO> nodesToDelete) {
        TreeSet<String> locations = new TreeSet<String>();
        for (IExecTestCasePO node : reusesSet) {
            INodePO parent = null;
            parent = node.getSpecAncestor();
            if (parent == null || nodesToDelete.contains(parent)) continue;
            locations.add("- " + parent.getName() + "\n");
        }
        String list = "";
        for (String string : locations) {
            list = String.valueOf(list) + string;
        }
        return new Object[]{specTcPO.getName(), locations.size(), list};
    }

    private boolean canDelete(Collection<INodePO> offspring) {
        for (INodePO node : offspring) {
            ITestSuitePO testSuite;
            List refTs;
            this.closeOpenEditor((IPersistentObject)node);
            if (node instanceof ISpecTestCasePO) {
                ISpecTestCasePO specTcPO = (ISpecTestCasePO)node;
                List execTestCases = NodePM.getInternalExecTestCases((String)specTcPO.getGuid(), (long)specTcPO.getParentProjectId());
                if (MultipleNodePM.allExecsFromList(offspring, (List)execTestCases)) continue;
                ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.I_REUSED_SPEC_TCS, (Object[])DeleteTCTSBrowserTreeItemHandler.createLocOfUseArray(specTcPO, execTestCases, offspring), null);
                return false;
            }
            if (!(node instanceof ITestSuitePO) || (refTs = NodePM.getInternalRefTestSuites((String)(testSuite = (ITestSuitePO)node).getGuid(), (long)testSuite.getParentProjectId())).size() <= 0) continue;
            ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.I_REUSED_TS);
            return false;
        }
        return true;
    }

    private void deleteSelection(IStructuredSelection selection) {
        HashSet<INodePO> set = new HashSet<INodePO>(selection.toList());
        final HashSet<INodePO> topNodes = new HashSet<INodePO>();
        for (INodePO node : set) {
            if (this.containsParent(set, node)) continue;
            topNodes.add(node);
        }
        if (topNodes.isEmpty()) {
            return;
        }
        final Collection allNodes = NodeBP.getOffspringCollection(topNodes);
        if (!this.canDelete(allNodes)) {
            return;
        }
        try {
            IProgressService ser = PlatformUI.getWorkbench().getProgressService();
            ser.run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    monitor.beginTask(Messages.DeleteNodes, topNodes.size());
                    DeleteNodesTransaction.deleteTopNodes(topNodes, allNodes, monitor);
                    monitor.done();
                }
            });
        }
        catch (InterruptedException | InvocationTargetException exception) {}
    }

    private boolean containsParent(Set<INodePO> set, INodePO node) {
        INodePO parent = node.getParentNode();
        while (parent != null) {
            if (set.contains(parent)) {
                return true;
            }
            parent = parent.getParentNode();
        }
        return false;
    }
}

