/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers.delete;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jubula.client.core.businessprocess.IParamNameMapper;
import org.eclipse.jubula.client.core.businessprocess.ParamNameBP;
import org.eclipse.jubula.client.core.businessprocess.ParamNameBPDecorator;
import org.eclipse.jubula.client.core.businessprocess.UnusedSpecTestCasesBP;
import org.eclipse.jubula.client.core.businessprocess.progress.ProgressMonitorTracker;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IEventExecTestCasePO;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.persistence.MultipleNodePM;
import org.eclipse.jubula.client.core.persistence.NodePM;
import org.eclipse.jubula.client.ui.handlers.AbstractSelectionBasedHandler;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.handlers.delete.DeleteNodesTransaction;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.utils.Utils;
import org.eclipse.jubula.client.ui.utils.DialogUtils;
import org.eclipse.jubula.client.ui.utils.ErrorHandlingUtil;
import org.eclipse.jubula.tools.internal.messagehandling.MessageIDs;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

public class DeleteUnusedHandler
extends AbstractSelectionBasedHandler {
    private static final int MAX_NODES_DISPLAYED = 10;

    private static void closeOpenEditor(IPersistentObject node) {
        IEditorPart editor = Utils.getEditorByPO(node);
        if (editor != null) {
            editor.getSite().getPage().closeEditor(editor, false);
        }
    }

    private static String createConfirmLabel(List<String> itemNames) {
        StringBuilder label = new StringBuilder(NLS.bind((String)Messages.DeleteUnusedAction, (Object)itemNames.size()));
        label.append("\n");
        label.append("\n");
        Iterator<String> iterator = itemNames.iterator();
        int size = 0;
        while (iterator.hasNext()) {
            label.append("- ");
            label.append(iterator.next().toString());
            label.append("\n");
            if (10 <= ++size) break;
        }
        if (iterator.hasNext()) {
            label.append("\n");
            label.append(NLS.bind((String)Messages.DeleteUnusedActionOverflow, (Object)(itemNames.size() - size)));
        }
        return label.toString();
    }

    private static List<MultipleNodePM.AbstractCmdHandle> createDeleteCommands(List<INodePO> nodesToDelete) {
        ArrayList<MultipleNodePM.AbstractCmdHandle> cmds = new ArrayList<MultipleNodePM.AbstractCmdHandle>(nodesToDelete.size());
        ParamNameBPDecorator dec = new ParamNameBPDecorator((IParamNameMapper)ParamNameBP.getInstance());
        for (INodePO node : nodesToDelete) {
            dec.clearAllNames();
            if (node instanceof ISpecTestCasePO) {
                cmds.add((MultipleNodePM.AbstractCmdHandle)new MultipleNodePM.DeleteTCHandle((ISpecTestCasePO)node, dec));
            }
            if (!(node instanceof IEventExecTestCasePO)) continue;
            cmds.add((MultipleNodePM.AbstractCmdHandle)new MultipleNodePM.DeleteEvHandle((IEventExecTestCasePO)node));
        }
        return cmds;
    }

    private static Object[] createLocOfUseArray(ISpecTestCasePO specTcPO, List<IExecTestCasePO> reusesSet, List<INodePO> nodesToDelete) {
        StringBuilder locOfUse = new StringBuilder();
        int size = 0;
        for (IExecTestCasePO node : reusesSet) {
            INodePO parent = node.getParentNode();
            if (parent == null || nodesToDelete.contains(parent)) continue;
            locOfUse.append("- ");
            locOfUse.append(parent.getName());
            locOfUse.append("\n");
            ++size;
        }
        return new Object[]{specTcPO.getName(), size, locOfUse.toString()};
    }

    private static boolean doesSetContainAnyParent(Set<INodePO> set, INodePO node) {
        INodePO parent = node.getParentNode();
        while (parent != null) {
            if (set.contains(parent)) {
                return true;
            }
            parent = parent.getParentNode();
        }
        return false;
    }

    private static List<INodePO> selectionToList(IStructuredSelection selection) {
        HashSet<INodePO> set = new HashSet<INodePO>(selection.toList());
        ArrayList<INodePO> top = new ArrayList<INodePO>();
        for (INodePO node : set) {
            if (DeleteUnusedHandler.doesSetContainAnyParent(set, node)) continue;
            top.add(node);
        }
        return top;
    }

    public Object executeImpl(ExecutionEvent event) {
        List<INodePO> nodeList = DeleteUnusedHandler.selectionToList(this.getSelection());
        if (this.isValid(nodeList)) {
            ArrayList<INodePO> unusedList = new ArrayList<INodePO>();
            for (INodePO node : nodeList) {
                unusedList.addAll(UnusedSpecTestCasesBP.getUnusedSpecTestCases((ISpecTestCasePO)((ISpecTestCasePO)node)));
            }
            if (unusedList.isEmpty()) {
                return null;
            }
            Collections.reverse(unusedList);
            if (this.isConfirmed(unusedList)) {
                try {
                    for (INodePO node : unusedList) {
                        DeleteUnusedHandler.closeOpenEditor((IPersistentObject)node);
                    }
                    PlatformUI.getWorkbench().getProgressService().run(true, false, (IRunnableWithProgress)new DeleteUnusedOperation(unusedList));
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return null;
    }

    private boolean isConfirmed(List<INodePO> top) {
        ArrayList<String> itemNames = new ArrayList<String>();
        for (INodePO obj : top) {
            if (obj instanceof INodePO) {
                itemNames.add(obj.getName());
                continue;
            }
            String name = String.valueOf(obj);
            if (StringUtils.isBlank((String)name)) continue;
            itemNames.add(name);
        }
        if (itemNames.isEmpty()) {
            return false;
        }
        MessageDialog dialog = new MessageDialog(this.getActiveShell(), Messages.DeleteUnusedActionShellTitle, null, DeleteUnusedHandler.createConfirmLabel(itemNames), 3, new String[]{Messages.DialogMessageButton_YES, Messages.DialogMessageButton_NO}, 0);
        dialog.create();
        DialogUtils.setWidgetNameForModalDialog((Dialog)dialog);
        dialog.open();
        return dialog.getReturnCode() == 0;
    }

    private boolean isValid(List<INodePO> top) {
        for (INodePO node : top) {
            ISpecTestCasePO specTcPO;
            List execTestCases;
            if (!(node instanceof ISpecTestCasePO) || MultipleNodePM.allExecsFromList(top, (List)(execTestCases = NodePM.getInternalExecTestCases((String)(specTcPO = (ISpecTestCasePO)node).getGuid(), (long)specTcPO.getParentProjectId())))) continue;
            ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.I_REUSED_SPEC_TCS, (Object[])DeleteUnusedHandler.createLocOfUseArray(specTcPO, execTestCases, top), null);
            return false;
        }
        return true;
    }

    private class DeleteUnusedOperation
    implements IRunnableWithProgress {
        private List<INodePO> m_deleteList;

        public DeleteUnusedOperation(List<INodePO> deleteList) {
            this.m_deleteList = deleteList;
        }

        public void run(IProgressMonitor monitor) {
            ProgressMonitorTracker instance = ProgressMonitorTracker.SINGLETON;
            Plugin.startLongRunning(Messages.DeleteUnusedProgress);
            instance.setProgressMonitor(monitor);
            monitor.beginTask(Messages.UIJobDeletingUnused, this.m_deleteList.size());
            DeleteNodesTransaction.deleteTopNodes(this.m_deleteList, this.m_deleteList, monitor);
            monitor.done();
            DataEventDispatcher.getInstance().fireTestresultChanged(DataEventDispatcher.TestresultState.Refresh);
            instance.setProgressMonitor(null);
            Plugin.stopLongRunning();
        }
    }
}

