/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers.edit;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IObjectMappingCategoryPO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.PoMaker;
import org.eclipse.jubula.client.ui.handlers.AbstractSelectionBasedHandler;
import org.eclipse.jubula.client.ui.rcp.dialogs.AssocOMtoSpecTCDialog;
import org.eclipse.jubula.client.ui.rcp.editors.IJBEditor;
import org.eclipse.jubula.client.ui.rcp.editors.JBEditorHelper;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class EditorOMAssocHandler
extends AbstractSelectionBasedHandler {
    protected Object executeImpl(ExecutionEvent event) throws ExecutionException {
        ISpecTestCasePO firstElement = (ISpecTestCasePO)this.getFirstElement(ISpecTestCasePO.class);
        IEditorPart editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        ((IJBEditor)editor).getEditorHelper().doEditorOperation(workingPo -> {
            if (firstElement != null) {
                AssocOMtoSpecTCDialog dialog = new AssocOMtoSpecTCDialog(this.getActiveShell(), firstElement);
                dialog.create();
                int result = dialog.open();
                if (result != 0) {
                    return;
                }
                this.saveNewSelection(firstElement, editor, dialog.getSelectedItems());
            }
        });
        return null;
    }

    private void saveNewSelection(ISpecTestCasePO specTC, IEditorPart editor, Collection<IObjectMappingCategoryPO> selectedItems) {
        ArrayList<IObjectMappingCategoryPO> toAdd;
        if (editor instanceof IJBEditor) {
            JBEditorHelper editHelper = ((IJBEditor)editor).getEditorHelper();
            editHelper.setDirty(true);
            toAdd = new ArrayList<IObjectMappingCategoryPO>();
            for (IObjectMappingCategoryPO category : selectedItems) {
                toAdd.add((IObjectMappingCategoryPO)editHelper.getEditSupport().getSession().find(PoMaker.getObjectMappingCategoryClass(), (Object)category.getId()));
            }
        } else {
            throw new IllegalArgumentException("IEdittorPart is not instance if IJBEditor");
        }
        specTC.setOmCategoryAssoc(new ArrayList(toAdd));
        DataEventDispatcher.getInstance().firePropertyChanged(false);
    }
}

