/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.provider.contentprovider;

import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.IReusedProjectPO;
import org.eclipse.jubula.client.core.model.ITestDataCategoryPO;
import org.eclipse.jubula.client.core.model.ITestDataCubePO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.ProjectPM;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.provider.contentprovider.AbstractNodeTreeContentProvider;
import org.eclipse.jubula.client.ui.rcp.search.result.BasicSearchResult;
import org.eclipse.jubula.tools.internal.exception.Assert;
import org.eclipse.jubula.tools.internal.exception.JBException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTreeViewContentProvider
extends AbstractNodeTreeContentProvider {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractTreeViewContentProvider.class);

    @Override
    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public Object getParent(Object element) {
        if (element instanceof INodePO) {
            INodePO node = (INodePO)element;
            INodePO parent = node.getParentNode();
            Long nodeProjId = node.getParentProjectId();
            if (node.isExecObjCont() || node.isSpecObjCont()) {
                return GeneralStorage.getInstance().getProject();
            }
            IProjectPO activeProject = GeneralStorage.getInstance().getProject();
            if (activeProject != null && nodeProjId != null && parent != null && !nodeProjId.equals(activeProject.getId()) && parent.isSpecObjCont()) {
                try {
                    String nodeProjGUID = ProjectPM.getGuidOfProjectId((Long)nodeProjId);
                    for (IReusedProjectPO reusedProject : activeProject.getUsedProjects()) {
                        if (nodeProjGUID == null || !nodeProjGUID.equals(reusedProject.getProjectGuid())) continue;
                        return reusedProject;
                    }
                }
                catch (JBException e) {
                    LOG.warn("Could not load referenced project information", (Throwable)e);
                }
            }
            return parent;
        }
        if (element instanceof IReusedProjectPO) {
            return GeneralStorage.getInstance().getProject();
        }
        if (element instanceof ITestDataCategoryPO) {
            return ((ITestDataCategoryPO)element).getParent();
        }
        if (element instanceof ITestDataCubePO) {
            return ((ITestDataCubePO)element).getParent();
        }
        if (element instanceof BasicSearchResult.SearchResultElement) {
            return null;
        }
        Assert.notReached((String)(String.valueOf(Messages.WrongTypeOfElement) + "!"));
        return null;
    }
}

