/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.provider.contentprovider;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.eclipse.jubula.client.core.model.ICategoryPO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.IReusedProjectPO;
import org.eclipse.jubula.client.core.persistence.ProjectPM;
import org.eclipse.jubula.client.ui.rcp.provider.contentprovider.AbstractTreeViewContentProvider;
import org.eclipse.jubula.client.ui.utils.ErrorHandlingUtil;
import org.eclipse.jubula.tools.internal.exception.JBException;

public class TestCaseTreeCompositeContentProvider
extends AbstractTreeViewContentProvider {
    private boolean m_onlyCategories = false;
    private boolean m_showReusedProjects = true;

    public TestCaseTreeCompositeContentProvider(boolean reuseds, boolean categories) {
        this.m_showReusedProjects = reuseds;
        this.m_onlyCategories = categories;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IProjectPO) {
            IProjectPO project = (IProjectPO)parentElement;
            ArrayList<INodePO> elements = new ArrayList<INodePO>();
            if (this.m_onlyCategories) {
                elements.add(((IProjectPO)parentElement).getSpecObjCont());
            } else {
                for (INodePO child : project.getUnmodSpecList()) {
                    elements.add(child);
                }
            }
            if (this.m_showReusedProjects) {
                elements.addAll(project.getUsedProjects());
            }
            return elements.toArray();
        }
        if (parentElement instanceof ICategoryPO) {
            List allChildren = ((ICategoryPO)parentElement).getUnmodifiableNodeList();
            if (!this.m_onlyCategories) {
                return allChildren.toArray();
            }
            ArrayList<INodePO> onlyCategories = new ArrayList<INodePO>();
            for (INodePO child : allChildren) {
                if (!(child instanceof ICategoryPO)) continue;
                onlyCategories.add(child);
            }
            return onlyCategories.toArray();
        }
        if (parentElement instanceof IReusedProjectPO) {
            try {
                IProjectPO reusedProject = ProjectPM.loadReusedProjectInMasterSession((IReusedProjectPO)((IReusedProjectPO)parentElement));
                if (reusedProject == null) {
                    return ArrayUtils.EMPTY_OBJECT_ARRAY;
                }
                ArrayList<INodePO> res = new ArrayList<INodePO>();
                for (INodePO spec : reusedProject.getUnmodSpecList()) {
                    if (this.m_onlyCategories && !(spec instanceof ICategoryPO)) continue;
                    res.add(spec);
                }
                return res.toArray();
            }
            catch (JBException e) {
                ErrorHandlingUtil.createMessageDialog((JBException)e, null, null);
            }
        }
        return ArrayUtils.EMPTY_OBJECT_ARRAY;
    }
}

