/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.search.query;

import org.apache.commons.lang.ObjectUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jubula.client.core.businessprocess.db.TestSuiteBP;
import org.eclipse.jubula.client.core.businessprocess.treeoperations.FindResponsibleNodesForComponentNameOp;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.IComponentNamePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.utils.ITreeNodeOperation;
import org.eclipse.jubula.client.core.utils.TreeTraverser;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.search.query.ShowWhereUsedComponentNameQuery;
import org.eclipse.osgi.util.NLS;

public class ShowResponsibleNodeForComponentName
extends ShowWhereUsedComponentNameQuery {
    private IAUTMainPO m_aut;

    public ShowResponsibleNodeForComponentName(IComponentNamePO compName, IAUTMainPO aut) {
        super(compName);
        this.m_aut = aut;
    }

    @Override
    public String getLabel() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getTimestamp());
        sb.append(":");
        sb.append(" ");
        sb.append(Messages.UIJobSearchingResponsibleCompNames);
        sb.append(" ");
        sb.append("\"");
        sb.append(this.getCompName().getName());
        sb.append("\"");
        return sb.toString();
    }

    @Override
    public IStatus run(IProgressMonitor monitor) {
        this.setMonitor(monitor);
        this.calculateUseOfLogicalName(this.getCompName().getGuid(), monitor);
        this.finished();
        return Status.OK_STATUS;
    }

    @Override
    protected void calculateUseOfLogicalName(String logicalName, IProgressMonitor monitor) {
        monitor.beginTask(NLS.bind((String)Messages.ShowResponsibleNodeOperation, (Object)this.getCompName().getName()), -1);
        this.calculateListOfComponentNamesUsingNodes(logicalName, this.m_aut);
    }

    private void calculateListOfComponentNamesUsingNodes(String logicalNameGUID, IAUTMainPO searchAUT) {
        IProjectPO currentProject = GeneralStorage.getInstance().getProject();
        for (ITestSuitePO ts : TestSuiteBP.getListOfTestSuites((IProjectPO)currentProject)) {
            IAUTMainPO aut = ts.getAut();
            if (aut == null || !ObjectUtils.equals((Object)aut.getGuid(), (Object)searchAUT.getGuid())) continue;
            FindResponsibleNodesForComponentNameOp op = new FindResponsibleNodesForComponentNameOp(logicalNameGUID);
            TreeTraverser traverser = new TreeTraverser((INodePO)ts, (ITreeNodeOperation)op);
            traverser.traverse(true);
            this.addAll(op.getNodes());
        }
    }
}

