/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.widgets;

import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.StatusLineLayoutData;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class StatusLineContributionItem
extends ContributionItem {
    public static final int DEFAULT_CHAR_WIDTH = 40;
    private int m_charWidth;
    private CLabel m_textLabel;
    private CLabel m_imageLabel;
    private String m_text = null;
    private Image m_image = null;
    private Composite m_statusLine = null;
    private int m_widthHint = -1;
    private int m_heightHint = -1;

    public StatusLineContributionItem(String id) {
        this(id, 40);
    }

    public StatusLineContributionItem(String id, int charWidth) {
        super(id);
        this.m_charWidth = charWidth;
        this.setVisible(false);
    }

    public void fill(Composite parent) {
        this.m_statusLine = parent;
        Label sep = new Label(parent, 2);
        this.m_textLabel = new CLabel(this.m_statusLine, 32);
        if (this.m_widthHint < 0) {
            GC gc = new GC((Drawable)this.m_statusLine);
            gc.setFont(this.m_statusLine.getFont());
            FontMetrics fm = gc.getFontMetrics();
            this.m_widthHint = fm.getAverageCharWidth() * this.m_charWidth;
            this.m_heightHint = fm.getHeight();
            gc.dispose();
        }
        StatusLineLayoutData data = new StatusLineLayoutData();
        this.m_textLabel.setLayoutData((Object)data);
        this.m_textLabel.setText(this.m_text);
        if (this.m_image != null) {
            this.m_imageLabel = new CLabel(parent, 0);
            this.m_imageLabel.setImage(this.m_image);
        }
        data = new StatusLineLayoutData();
        data.heightHint = this.m_heightHint;
        sep.setLayoutData((Object)data);
    }

    public void setText(String text) {
        if (text == null) {
            throw new NullPointerException();
        }
        this.m_text = text;
        if (this.m_textLabel != null && !this.m_textLabel.isDisposed()) {
            this.m_textLabel.setText(this.m_text);
        }
        if (this.m_text.length() == 0) {
            if (this.isVisible()) {
                this.updateContributionManager(false);
            }
        } else if (!this.isVisible()) {
            this.updateContributionManager(true);
        }
    }

    private void updateContributionManager(boolean visible) {
        this.setVisible(visible);
        IContributionManager contributionManager = this.getParent();
        if (contributionManager != null) {
            contributionManager.update(true);
        }
    }

    public void setImage(Image image) {
        this.m_image = image;
    }

    public void setMessage(Image image, String text) {
        this.setImage(image);
        this.setText(text);
    }
}

