/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.wizards.refactor.pages;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jubula.client.core.businessprocess.CalcTypes;
import org.eclipse.jubula.client.core.businessprocess.CompNamesBP;
import org.eclipse.jubula.client.core.businessprocess.IComponentNameCache;
import org.eclipse.jubula.client.core.businessprocess.IWritableComponentNameCache;
import org.eclipse.jubula.client.core.model.ICompNamesPairPO;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.persistence.EditSupport;
import org.eclipse.jubula.client.ui.constants.IconConstants;
import org.eclipse.jubula.client.ui.rcp.editors.AbstractJBEditor;
import org.eclipse.jubula.client.ui.rcp.editors.TestSuiteEditor;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.provider.labelprovider.GeneralLabelProvider;
import org.eclipse.jubula.client.ui.rcp.widgets.ComponentNamesTableComposite;
import org.eclipse.jubula.tools.internal.i18n.CompSystemI18n;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class MatchComponentNamesPage
extends WizardPage {
    private final AbstractJBEditor m_editor;
    private ComponentNamesTableComposite m_cntc;
    private final List<INodePO> m_execTCList;
    private Map<ICompNamesPairPO, IExecTestCasePO> m_parents = new HashMap<ICompNamesPairPO, IExecTestCasePO>();

    public MatchComponentNamesPage(String pageName, AbstractJBEditor editor, List<INodePO> execTCList) {
        super(pageName, Messages.ReplaceTCRWizard_matchComponentNames_title, null);
        this.m_editor = editor;
        this.m_execTCList = execTCList;
    }

    public void createControl(Composite parent) {
        SashForm sash = new SashForm(parent, 256);
        sash.setLayout((Layout)new FillLayout(768));
        Composite leftSashContent = new Composite((Composite)sash, 0);
        leftSashContent.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        new Label(leftSashContent, 0).setText(Messages.ReplaceTCRWizard_matchComponentNames_oldInterface);
        TreeViewer tv = new TreeViewer(leftSashContent);
        tv.setContentProvider((IContentProvider)new MatchCompNamesPageTreeContentProvider());
        tv.setLabelProvider((IBaseLabelProvider)new MatchCompNamesPageTreeLabelProvider());
        tv.setInput(this.m_execTCList);
        tv.getTree().setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        tv.expandAll();
        Composite rightSashContent = new Composite((Composite)sash, 0);
        rightSashContent.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        new Label(rightSashContent, 0).setText(Messages.ReplaceTCRWizard_matchComponentNames_newInterface);
        this.m_cntc = new ComponentNamesTableComposite(rightSashContent, 0);
        this.m_cntc.setSelectedExecNodeOwner((IWorkbenchPart)this.m_editor);
        if (this.m_editor instanceof TestSuiteEditor) {
            this.m_cntc.controlPropagation(false);
        }
        sash.setWeights(new int[]{1, 2});
        this.setControl((Control)sash);
    }

    public void setSelectedExecNode(IExecTestCasePO replacement) {
        this.m_cntc.setSelectedExecNode(replacement);
    }

    public void performHelp() {
        PlatformUI.getWorkbench().getHelpSystem().displayHelp("org.eclipse.jubula.client.ua.help.refactorReplaceMatchComponentNamesWizardPagePageContextId");
    }

    public class MatchCompNamesPageTreeContentProvider
    implements ITreeContentProvider {
        private CompNamesBP m_cnBP = new CompNamesBP();

        public void dispose() {
            MatchComponentNamesPage.this.m_parents.clear();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            MatchComponentNamesPage.this.m_parents.clear();
        }

        public Object[] getElements(Object inputElement) {
            return ((List)inputElement).toArray();
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof IExecTestCasePO) {
                IExecTestCasePO execTC = (IExecTestCasePO)parentElement;
                List compPairs = this.m_cnBP.getAllCompNamesPairs(execTC);
                if (compPairs.size() > 0) {
                    for (ICompNamesPairPO pair : compPairs) {
                        MatchComponentNamesPage.this.m_parents.put(pair, execTC);
                    }
                    return compPairs.toArray();
                }
                return new String[]{Messages.NoComponentNames};
            }
            return ArrayUtils.EMPTY_OBJECT_ARRAY;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }
    }

    public class MatchCompNamesPageTreeLabelProvider
    extends GeneralLabelProvider {
        @Override
        public String getText(Object element) {
            if (element instanceof ICompNamesPairPO) {
                ICompNamesPairPO pair = (ICompNamesPairPO)element;
                EditSupport supp = MatchComponentNamesPage.this.m_editor.getEditorHelper().getEditSupport();
                IWritableComponentNameCache cache = MatchComponentNamesPage.this.m_editor.getCompNameCache();
                StringBuilder sb = new StringBuilder(cache.getNameByGuid(pair.getSecondName()));
                if (StringUtils.isEmpty((String)pair.getType())) {
                    CalcTypes.recalculateCompNamePairs((IComponentNameCache)cache, (INodePO)((INodePO)supp.getWorkVersion()));
                }
                sb.append(" ").append("[").append(CompSystemI18n.getString((String)pair.getType())).append("]");
                return sb.toString();
            }
            return super.getText(element);
        }

        @Override
        public Image getImage(Object element) {
            if (element instanceof ICompNamesPairPO) {
                if (((ICompNamesPairPO)element).isPropagated()) {
                    return IconConstants.PROPAGATED_LOGICAL_NAME_IMAGE;
                }
                return IconConstants.LOGICAL_NAME_IMAGE;
            }
            return super.getImage(element);
        }
    }
}

