/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.actions;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.m2e.core.ui.internal.UpdateMavenProjectJob;
import org.eclipse.m2e.core.ui.internal.actions.SelectionUtil;
import org.eclipse.m2e.core.ui.internal.dialogs.UpdateMavenProjectsDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateMavenProjectCommandHandler
extends AbstractHandler {
    private static final Logger log = LoggerFactory.getLogger(UpdateMavenProjectCommandHandler.class);

    public Object execute(ExecutionEvent event) {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        Shell shell = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getShell();
        IProject[] projects = SelectionUtil.getProjects(selection, false);
        if (projects == null || projects.length == 0) {
            projects = this.getProjectInActiveEditor(event);
        }
        if (projects == null || projects.length == 0) {
            projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        }
        UpdateMavenProjectCommandHandler.openUpdateProjectsDialog(shell, projects);
        return null;
    }

    private IProject[] getProjectInActiveEditor(ExecutionEvent event) {
        try {
            IFileEditorInput fileInput;
            IProject project;
            IEditorPart editorPart;
            IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
            if (activePart instanceof IEditorPart && (editorPart = (IEditorPart)activePart).getEditorInput() instanceof IFileEditorInput && (project = (fileInput = (IFileEditorInput)editorPart.getEditorInput()).getFile().getProject()) != null && project.isAccessible() && project.hasNature("org.eclipse.m2e.core.maven2Nature")) {
                return new IProject[]{project};
            }
        }
        catch (CoreException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
        return null;
    }

    static void openUpdateProjectsDialog(Shell shell, IProject[] projects) {
        UpdateMavenProjectsDialog dialog = new UpdateMavenProjectsDialog(shell, projects);
        if (dialog.open() == 0) {
            new UpdateMavenProjectJob(dialog.getSelectedProjects(), dialog.isOffline(), dialog.isForceUpdateDependencies(), dialog.isUpdateConfiguration(), dialog.isCleanProjects(), dialog.isRefreshFromLocal()).schedule();
        }
    }
}

