/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.mat.collect.ArrayInt;
import org.eclipse.mat.collect.HashMapIntObject;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.query.Bytes;
import org.eclipse.mat.query.Column;
import org.eclipse.mat.query.IContextObject;
import org.eclipse.mat.query.IContextObjectSet;
import org.eclipse.mat.query.IDecorator;
import org.eclipse.mat.query.IIconProvider;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.IResultTree;
import org.eclipse.mat.query.ResultMetaData;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.CommandName;
import org.eclipse.mat.query.annotations.HelpUrl;
import org.eclipse.mat.query.annotations.Icon;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.GCRootInfo;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.query.Icons;
import org.eclipse.mat.snapshot.query.ObjectListResult;
import org.eclipse.mat.util.IProgressListener;

@CommandName(value="gc_roots")
@Icon(value="/META-INF/icons/roots.gif")
@HelpUrl(value="/org.eclipse.mat.ui.help/concepts/gcroots.html")
public class GCRootsQuery
implements IQuery {
    private static final URL ICON = Icons.getURL("roots.gif");
    @Argument
    public ISnapshot snapshot;

    public IResult execute(IProgressListener listener) throws Exception {
        int[] roots = this.snapshot.getGCRoots();
        HashMapIntObject rootsByType = new HashMapIntObject();
        int[] nArray = roots;
        int n = roots.length;
        int n2 = 0;
        while (n2 < n) {
            int root = nArray[n2];
            GCRootInfo[] info = this.snapshot.getGCRootInfo(root);
            int classId = this.snapshot.getClassOf(root).getObjectId();
            GCRootInfo[] gCRootInfoArray = info;
            int n3 = info.length;
            int n4 = 0;
            while (n4 < n3) {
                ArrayInt byClass;
                GCRootInfo rootInfo = gCRootInfoArray[n4];
                HashMapIntObject type = (HashMapIntObject)rootsByType.get(rootInfo.getType());
                if (type == null) {
                    type = new HashMapIntObject();
                    rootsByType.put(rootInfo.getType(), (Object)type);
                }
                if ((byClass = (ArrayInt)type.get(classId)) == null) {
                    byClass = new ArrayInt();
                    type.put(classId, (Object)byClass);
                }
                byClass.add(root);
                ++n4;
            }
            ++n2;
        }
        if (listener.isCanceled()) {
            throw new IProgressListener.OperationCanceledException();
        }
        ArrayList<GCType> types = new ArrayList<GCType>();
        Iterator iter = rootsByType.entries();
        while (iter.hasNext()) {
            HashMapIntObject.Entry entry = (HashMapIntObject.Entry)iter.next();
            GCType type = new GCType(GCRootInfo.getTypeAsString(entry.getKey()), entry.getKey());
            types.add(type);
            Iterator iterObjects = ((HashMapIntObject)entry.getValue()).entries();
            while (iterObjects.hasNext()) {
                HashMapIntObject.Entry entryObjects = (HashMapIntObject.Entry)iterObjects.next();
                ClassRecord record = new ClassRecord((IClass)this.snapshot.getObject(entryObjects.getKey()), ((ArrayInt)entryObjects.getValue()).toArray());
                type.records.add(record);
                type.count += record.objectIds.length;
            }
            Collections.sort(type.records);
        }
        Collections.sort(types);
        return new Result(this.snapshot, roots, types);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ClassRecord
    implements Comparable<ClassRecord> {
        final int classId;
        final String name;
        final int[] objectIds;

        public ClassRecord(IClass object, int[] objectIds) {
            this.classId = object.getObjectId();
            this.name = object.getName();
            this.objectIds = objectIds;
        }

        @Override
        public int compareTo(ClassRecord o) {
            return this.objectIds.length > o.objectIds.length ? -1 : (this.objectIds.length < o.objectIds.length ? 1 : 0);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GCType
    implements Comparable<GCType> {
        String name;
        int count;
        int type;
        List<ClassRecord> records = new ArrayList<ClassRecord>();

        public GCType(String name, int type) {
            this.name = name;
            this.type = type;
        }

        @Override
        public int compareTo(GCType other) {
            return this.count > other.count ? -1 : (this.count < other.count ? 1 : 0);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Result
    implements IResultTree,
    IIconProvider,
    IDecorator {
        private List<GCType> rootTypes;
        private HashMapIntObject<Object> root2element;
        private ObjectListResult.Outbound objectList;

        public Result(ISnapshot snapshot, int[] roots, List<GCType> rootTypes) {
            this.rootTypes = rootTypes;
            this.root2element = new HashMapIntObject();
            this.objectList = new ObjectListResult.Outbound(snapshot, roots);
            for (Object o : this.objectList.getElements()) {
                this.root2element.put(this.objectList.getContext(o).getObjectId(), o);
            }
        }

        public ResultMetaData getResultMetaData() {
            return new ResultMetaData.Builder().setIsPreSortedBy(1, Column.SortDirection.DESC).build();
        }

        public Column[] getColumns() {
            return new Column[]{new Column(Messages.Column_ClassName).decorator((IDecorator)this), new Column(Messages.Column_Objects, Integer.TYPE), new Column(Messages.Column_ShallowHeap, Bytes.class).noTotals(), new Column(Messages.Column_RetainedHeap, Bytes.class).noTotals()};
        }

        public List<?> getElements() {
            return this.rootTypes;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof GCType) {
                return true;
            }
            if (element instanceof ClassRecord) {
                return true;
            }
            return this.objectList.hasChildren(element);
        }

        public List<?> getChildren(Object parent) {
            if (parent instanceof GCType) {
                return ((GCType)parent).records;
            }
            if (parent instanceof ClassRecord) {
                return this.asList(((ClassRecord)parent).objectIds);
            }
            return this.objectList.getChildren(parent);
        }

        private List<?> asList(int[] objectIds) {
            ArrayList<Object> answer = new ArrayList<Object>(objectIds.length);
            int[] nArray = objectIds;
            int n = objectIds.length;
            int n2 = 0;
            while (n2 < n) {
                int id = nArray[n2];
                answer.add(this.root2element.get(id));
                ++n2;
            }
            return answer;
        }

        public Object getColumnValue(Object row, int columnIndex) {
            if (row instanceof GCType) {
                GCType type = (GCType)row;
                switch (columnIndex) {
                    case 0: {
                        return type.name;
                    }
                    case 1: {
                        return type.count;
                    }
                }
                return null;
            }
            if (row instanceof ClassRecord) {
                ClassRecord record = (ClassRecord)row;
                switch (columnIndex) {
                    case 0: {
                        return record.name;
                    }
                    case 1: {
                        return record.objectIds.length;
                    }
                }
                return null;
            }
            switch (columnIndex) {
                case 0: {
                    return this.objectList.getColumnValue(row, columnIndex);
                }
                case 1: {
                    return null;
                }
            }
            return this.objectList.getColumnValue(row, columnIndex - 1);
        }

        public IContextObject getContext(final Object row) {
            if (row instanceof GCType) {
                return new IContextObjectSet(){

                    public int getObjectId() {
                        return -1;
                    }

                    public int[] getObjectIds() {
                        ArrayInt roots = new ArrayInt();
                        for (ClassRecord record : ((GCType)row).records) {
                            roots.addAll(record.objectIds);
                        }
                        return roots.toArray();
                    }

                    public String getOQL() {
                        return "SELECT OBJECTS r FROM OBJECTS ${snapshot}.@GCRoots r WHERE (SELECT s FROM OBJECTS ${snapshot}.getGCRootInfo(r) s WHERE s.@type = " + ((GCType)row).type + ") != null";
                    }
                };
            }
            if (row instanceof ClassRecord) {
                return new IContextObjectSet(){

                    public int getObjectId() {
                        return ((ClassRecord)row).classId;
                    }

                    public int[] getObjectIds() {
                        return ((ClassRecord)row).objectIds;
                    }

                    public String getOQL() {
                        return null;
                    }
                };
            }
            return this.objectList.getContext(row);
        }

        public String prefix(Object row) {
            if (row instanceof GCType) {
                return null;
            }
            if (row instanceof ClassRecord) {
                return null;
            }
            return this.objectList.prefix(row);
        }

        public String suffix(Object row) {
            if (row instanceof GCType) {
                return null;
            }
            if (row instanceof ClassRecord) {
                return null;
            }
            return this.objectList.suffix(row);
        }

        public URL getIcon(Object row) {
            if (row instanceof GCType) {
                return ICON;
            }
            if (row instanceof ClassRecord) {
                return Icons.CLASS;
            }
            return this.objectList.getIcon(row);
        }
    }
}

