/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.ui.util;

import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public abstract class PreferenceStoreFacade
implements IPreferenceStore {
    private final ListenerList listeners = new ListenerList(1);
    private IPropertyChangeListener forwardingListener;
    protected IPreferenceStore delegate;

    protected PreferenceStoreFacade(IPreferenceStore preferenceStore) {
        this.delegate = preferenceStore;
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.listeners.add((Object)listener);
        if (this.forwardingListener == null) {
            this.forwardingListener = event -> this.firePropertyChangeEvent(event.getProperty(), event.getOldValue(), event.getNewValue());
            this.delegate.addPropertyChangeListener(this.forwardingListener);
        }
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.listeners.remove((Object)listener);
        if (this.listeners.isEmpty() && this.forwardingListener != null) {
            this.delegate.removePropertyChangeListener(this.forwardingListener);
            this.forwardingListener = null;
        }
    }

    public void firePropertyChangeEvent(String name, Object oldValue, Object newValue) {
        if (this.listeners.isEmpty()) {
            return;
        }
        if (newValue instanceof Boolean) {
            newValue = this.getBoolean(name);
        } else if (newValue instanceof Integer) {
            newValue = this.getInt(name);
        } else if (newValue instanceof Long) {
            newValue = this.getLong(name);
        } else if (newValue instanceof Double) {
            newValue = this.getDouble(name);
        } else if (newValue instanceof Float) {
            newValue = Float.valueOf(this.getFloat(name));
        } else if (newValue instanceof String) {
            newValue = this.getString(name);
        }
        if (newValue == oldValue || newValue != null && newValue.equals(oldValue)) {
            return;
        }
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, name, oldValue, newValue);
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            IPropertyChangeListener listener = (IPropertyChangeListener)o;
            listener.propertyChange(event);
            ++n2;
        }
    }

    public boolean contains(String name) {
        return this.delegate.contains(name);
    }

    public boolean getBoolean(String name) {
        return this.delegate.getBoolean(name);
    }

    public boolean getDefaultBoolean(String name) {
        return this.delegate.getDefaultBoolean(name);
    }

    public double getDefaultDouble(String name) {
        return this.delegate.getDefaultDouble(name);
    }

    public float getDefaultFloat(String name) {
        return this.delegate.getDefaultFloat(name);
    }

    public int getDefaultInt(String name) {
        return this.delegate.getDefaultInt(name);
    }

    public long getDefaultLong(String name) {
        return this.delegate.getDefaultLong(name);
    }

    public String getDefaultString(String name) {
        return this.delegate.getDefaultString(name);
    }

    public double getDouble(String name) {
        return this.delegate.getDouble(name);
    }

    public float getFloat(String name) {
        return this.delegate.getFloat(name);
    }

    public int getInt(String name) {
        return this.delegate.getInt(name);
    }

    public long getLong(String name) {
        return this.delegate.getLong(name);
    }

    public String getString(String name) {
        return this.delegate.getString(name);
    }

    public boolean isDefault(String name) {
        return this.delegate.isDefault(name);
    }

    public boolean needsSaving() {
        return this.delegate.needsSaving();
    }

    public void putValue(String name, String value) {
        this.delegate.putValue(name, value);
    }

    public void setDefault(String name, boolean value) {
        this.delegate.setDefault(name, value);
    }

    public void setDefault(String name, double value) {
        this.delegate.setDefault(name, value);
    }

    public void setDefault(String name, float value) {
        this.delegate.setDefault(name, value);
    }

    public void setDefault(String name, int value) {
        this.delegate.setDefault(name, value);
    }

    public void setDefault(String name, long value) {
        this.delegate.setDefault(name, value);
    }

    public void setDefault(String name, String defaultObject) {
        this.delegate.setDefault(name, defaultObject);
    }

    public void setToDefault(String name) {
        this.delegate.setToDefault(name);
    }

    public void setValue(String name, boolean value) {
        this.delegate.setValue(name, value);
    }

    public void setValue(String name, double value) {
        this.delegate.setValue(name, value);
    }

    public void setValue(String name, float value) {
        this.delegate.setValue(name, value);
    }

    public void setValue(String name, int value) {
        this.delegate.setValue(name, value);
    }

    public void setValue(String name, long value) {
        this.delegate.setValue(name, value);
    }

    public void setValue(String name, String value) {
        this.delegate.setValue(name, value);
    }
}

