/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.ui.util.css.editor;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.swt.custom.StyleRange;

class CommentDamagerRepairer
implements IPresentationDamager,
IPresentationRepairer {
    private IDocument document;
    private final TextAttribute defaultTextAttribute;

    public CommentDamagerRepairer(TextAttribute defaultTextAttribute) {
        this.defaultTextAttribute = defaultTextAttribute;
    }

    public IRegion getDamageRegion(ITypedRegion partition, DocumentEvent event, boolean documentPartitioningChanged) {
        if (!documentPartitioningChanged) {
            try {
                IRegion lineRegion = this.document.getLineInformationOfOffset(event.getOffset());
                int start = Math.max(lineRegion.getOffset(), partition.getOffset());
                int end = event.getOffset();
                end = event.getText() == null ? (end += event.getLength()) : (end += event.getText().length());
                end = lineRegion.getOffset() <= end && end <= lineRegion.getOffset() + lineRegion.getLength() ? lineRegion.getOffset() + lineRegion.getLength() : this.toLineEnd(end);
                int partitionEnd = partition.getOffset() + partition.getLength();
                end = Math.min(partitionEnd, end);
                return new Region(start, end - start);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return partition;
    }

    private int toLineEnd(int offset) throws BadLocationException {
        IRegion lineRegion = this.document.getLineInformationOfOffset(offset);
        int lineEndOffset = lineRegion.getOffset() + lineRegion.getLength();
        if (offset <= lineEndOffset) {
            return lineEndOffset;
        }
        int line = this.document.getLineOfOffset(offset);
        try {
            lineRegion = this.document.getLineInformation(line + 1);
            lineEndOffset = lineRegion.getOffset() + lineRegion.getLength();
            return lineEndOffset;
        }
        catch (BadLocationException x) {
            return this.document.getLength();
        }
    }

    public void setDocument(IDocument document) {
        this.document = document;
    }

    public void createPresentation(TextPresentation presentation, ITypedRegion damage) {
        presentation.addStyleRange(new StyleRange(damage.getOffset(), damage.getLength(), this.defaultTextAttribute.getForeground(), this.defaultTextAttribute.getBackground(), this.defaultTextAttribute.getStyle()));
    }
}

