/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.export.file;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.export.FileOutputStreamProvider;
import org.eclipse.nebula.widgets.nattable.export.ILayerExporter;
import org.eclipse.nebula.widgets.nattable.export.IOutputStreamProvider;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.papyrus.infra.nattable.Activator;
import org.eclipse.swt.widgets.Shell;

public class PapyrusFileExporter
implements ILayerExporter {
    private final IOutputStreamProvider outputStreamProvider;
    private final String fileName;

    public PapyrusFileExporter() {
        this((IOutputStreamProvider)new FileOutputStreamProvider("table_export.txt", new String[]{"Text (*.txt)"}, new String[]{"*.txt"}));
    }

    public PapyrusFileExporter(String fileName) {
        this(null, fileName);
    }

    public PapyrusFileExporter(IOutputStreamProvider outputStreamProvider) {
        this(outputStreamProvider, null);
    }

    private PapyrusFileExporter(IOutputStreamProvider outputStreamProvider, String fileName) {
        this.outputStreamProvider = outputStreamProvider;
        this.fileName = fileName;
    }

    public OutputStream getOutputStream(Shell shell) {
        OutputStream result = null;
        if (this.fileName != null) {
            try {
                result = new PrintStream(this.fileName);
            }
            catch (FileNotFoundException e) {
                Activator.log.error((Throwable)e);
            }
        } else {
            result = this.outputStreamProvider.getOutputStream(shell);
        }
        return result;
    }

    public void exportBegin(OutputStream outputStream) throws IOException {
    }

    public void exportEnd(OutputStream outputStream) throws IOException {
        outputStream.flush();
    }

    public void exportLayerBegin(OutputStream outputStream, String layerName) throws IOException {
    }

    public void exportLayerEnd(OutputStream outputStream, String layerName) throws IOException {
    }

    public void exportRowBegin(OutputStream outputStream, int rowPosition) throws IOException {
    }

    public void exportRowEnd(OutputStream outputStream, int rowPosition) throws IOException {
    }

    public void exportCell(OutputStream outputStream, Object exportDisplayValue, ILayerCell cell, IConfigRegistry configRegistry) throws IOException {
        outputStream.write(this.asBytes(exportDisplayValue != null ? exportDisplayValue.toString() : ""));
        if (cell.getColumnPosition() < cell.getLayer().getColumnCount() - 1) {
            outputStream.write(this.asBytes("\t"));
        } else if (cell.getRowPosition() < cell.getLayer().getRowCount() - 1) {
            outputStream.write(this.asBytes("\n"));
        }
    }

    private byte[] asBytes(String string) {
        return string.getBytes();
    }

    public Object getResult() {
        Object result = null;
        result = this.fileName != null ? this.fileName : this.outputStreamProvider.getResult();
        return result;
    }
}

