/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.alf.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.papyrus.uml.alf.AlfFactory;
import org.eclipse.papyrus.uml.alf.AlfPackage;
import org.eclipse.papyrus.uml.alf.ElementReference;
import org.eclipse.papyrus.uml.alf.ExternalElementReference;
import org.eclipse.papyrus.uml.alf.ImportedMember;
import org.eclipse.papyrus.uml.alf.InternalElementReference;
import org.eclipse.papyrus.uml.alf.Member;
import org.eclipse.papyrus.uml.alf.MemberDefinition;
import org.eclipse.papyrus.uml.alf.Model;
import org.eclipse.papyrus.uml.alf.ModelNamespace;
import org.eclipse.papyrus.uml.alf.NamespaceDefinition;
import org.eclipse.papyrus.uml.alf.PackageDefinition;
import org.eclipse.papyrus.uml.alf.QualifiedName;
import org.eclipse.papyrus.uml.alf.UnitDefinition;
import org.eclipse.papyrus.uml.alf.impl.PackageDefinitionImpl;
import org.eclipse.papyrus.uml.tools.utils.NameResolutionUtils;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.UMLPackage;

public class ModelNamespaceImpl
extends PackageDefinitionImpl
implements ModelNamespace {
    private Namespace contextNamespace = null;
    private String modelUnitName = null;
    private NamespaceDefinition modelUnitNamespace = null;
    private Member modelUnitMember = null;
    protected static final EOperation.Internal.InvocationDelegate OUTER_SCOPE__EINVOCATION_DELEGATE = ((EOperation.Internal)AlfPackage.eINSTANCE.getModelNamespace__OuterScope()).getInvocationDelegate();
    protected static final EOperation.Internal.InvocationDelegate MODEL_SCOPE__EINVOCATION_DELEGATE = ((EOperation.Internal)AlfPackage.eINSTANCE.getModelNamespace__ModelScope()).getInvocationDelegate();
    protected static final EOperation.Internal.InvocationDelegate QUALIFIED_NAME__EINVOCATION_DELEGATE = ((EOperation.Internal)AlfPackage.eINSTANCE.getModelNamespace__QualifiedName()).getInvocationDelegate();
    protected static final EOperation.Internal.InvocationDelegate RESOLVE_IN_SCOPE_STRING__EINVOCATION_DELEGATE = ((EOperation.Internal)AlfPackage.eINSTANCE.getModelNamespace__ResolveInScope__String()).getInvocationDelegate();
    protected static final EOperation.Internal.InvocationDelegate RESOLVE_ASSOCIATION_END_ELEMENT_REFERENCE_STRING__EINVOCATION_DELEGATE = ((EOperation.Internal)AlfPackage.eINSTANCE.getModelNamespace__ResolveAssociationEnd__ElementReference_String()).getInvocationDelegate();
    protected static final EOperation.Internal.InvocationDelegate APPLIED_PROFILES__EINVOCATION_DELEGATE = ((EOperation.Internal)AlfPackage.eINSTANCE.getModelNamespace__AppliedProfiles()).getInvocationDelegate();
    protected static final EOperation.Internal.InvocationDelegate STUB_FOR_UNIT_DEFINITION__EINVOCATION_DELEGATE = ((EOperation.Internal)AlfPackage.eINSTANCE.getModelNamespace__StubFor__UnitDefinition()).getInvocationDelegate();

    protected ModelNamespaceImpl() {
    }

    protected static Member asMember(ElementReference reference) {
        ImportedMember importedMember = AlfFactory.eINSTANCE.createImportedMember();
        importedMember.setName(reference.name());
        importedMember.setReferent(reference);
        Member member = AlfFactory.eINSTANCE.createMember();
        member.setVisibility("public");
        member.setDefinition(importedMember);
        return member;
    }

    public void setContextNamespace(Namespace namespace) {
        this.contextNamespace = namespace;
        if (namespace == null || namespace.getName() == null) {
            this.setName(null);
        } else {
            this.setName("'" + namespace.getName().replace("\\", "\\\\").replace("'", "\\'") + "'");
        }
    }

    public Namespace getContextNamespace() {
        if (this.contextNamespace == null) {
            this.setContextNamespace((Namespace)new Model());
        }
        return this.contextNamespace;
    }

    public void setModelUnit(NamespaceDefinition namespace) {
        if (namespace != this.modelUnitNamespace) {
            this.modelUnitNamespace = namespace;
            this.modelUnitName = namespace.getName();
            InternalElementReference reference = AlfFactory.eINSTANCE.createInternalElementReference();
            reference.setElement(namespace);
            this.modelUnitMember = ModelNamespaceImpl.asMember(reference);
            this.getOwnedMember().clear();
        }
    }

    public Member addOwnedMember(MemberDefinition definition) {
        Member member2;
        EList<Member> ownedMembers = this.getOwnedMember();
        String name = definition.getName();
        for (Member member2 : ownedMembers) {
            if (!member2.getDefinition().getName().equals(name)) continue;
            return member2;
        }
        member2 = AlfFactory.eINSTANCE.createMember();
        member2.setDefinition(definition);
        ownedMembers.add((Object)member2);
        return member2;
    }

    @Override
    protected EClass eStaticClass() {
        return AlfPackage.eINSTANCE.getModelNamespace();
    }

    @Override
    public ElementReference context() {
        ExternalElementReference reference = AlfFactory.eINSTANCE.createExternalElementReference();
        reference.setElement((EObject)this.getContextNamespace());
        return reference;
    }

    @Override
    public ElementReference outerScope() {
        try {
            return (ElementReference)OUTER_SCOPE__EINVOCATION_DELEGATE.dynamicInvoke((InternalEObject)this, null);
        }
        catch (InvocationTargetException ite) {
            throw new WrappedException((Exception)ite);
        }
    }

    @Override
    public ElementReference modelScope() {
        try {
            return (ElementReference)MODEL_SCOPE__EINVOCATION_DELEGATE.dynamicInvoke((InternalEObject)this, null);
        }
        catch (InvocationTargetException ite) {
            throw new WrappedException((Exception)ite);
        }
    }

    @Override
    public QualifiedName qualifiedName() {
        try {
            return (QualifiedName)QUALIFIED_NAME__EINVOCATION_DELEGATE.dynamicInvoke((InternalEObject)this, null);
        }
        catch (InvocationTargetException ite) {
            throw new WrappedException((Exception)ite);
        }
    }

    @Override
    public EList<Member> resolveInScope(String name) {
        try {
            return (EList)RESOLVE_IN_SCOPE_STRING__EINVOCATION_DELEGATE.dynamicInvoke((InternalEObject)this, (EList)new BasicEList.UnmodifiableEList(1, new Object[]{name}));
        }
        catch (InvocationTargetException ite) {
            throw new WrappedException((Exception)ite);
        }
    }

    @Override
    public EList<Member> resolveInRoot(String name) {
        BasicEList members = new BasicEList();
        if (name != null && name.equals(this.modelUnitName)) {
            members.add((Object)this.modelUnitMember);
        } else {
            ExternalElementReference namespace = AlfFactory.eINSTANCE.createExternalElementReference();
            namespace.setElement((EObject)this.getContextNamespace());
            for (ElementReference reference : namespace.resolve(name)) {
                members.add((Object)ModelNamespaceImpl.asMember(reference));
            }
        }
        return members;
    }

    @Override
    public EList<ElementReference> appliedProfiles() {
        try {
            return (EList)APPLIED_PROFILES__EINVOCATION_DELEGATE.dynamicInvoke((InternalEObject)this, null);
        }
        catch (InvocationTargetException ite) {
            throw new WrappedException((Exception)ite);
        }
    }

    @Override
    public ElementReference stubFor(UnitDefinition unit) {
        try {
            return (ElementReference)STUB_FOR_UNIT_DEFINITION__EINVOCATION_DELEGATE.dynamicInvoke((InternalEObject)this, (EList)new BasicEList.UnmodifiableEList(1, new Object[]{unit}));
        }
        catch (InvocationTargetException ite) {
            throw new WrappedException((Exception)ite);
        }
    }

    @Override
    public EList<ElementReference> ModelNamespace_appliedProfiles() {
        BasicEList profiles = new BasicEList();
        Package nearestPackage = this.getContextNamespace().getNearestPackage();
        if (nearestPackage != null) {
            for (Profile appliedProfile : nearestPackage.getAllAppliedProfiles()) {
                ExternalElementReference reference = AlfFactory.eINSTANCE.createExternalElementReference();
                reference.setElement((EObject)appliedProfile);
                profiles.add((Object)reference);
            }
        }
        return profiles;
    }

    @Override
    public EList<ElementReference> resolvePathName(String pathName) {
        return ModelNamespaceImpl.resolvePathName(pathName, (Namespace)this.getContextNamespace().getModel());
    }

    public static EList<ElementReference> resolvePathName(String pathName, Namespace context) {
        BasicEList references = new BasicEList();
        List elements = NameResolutionUtils.getNamedElements((String)pathName, (Namespace)context, (EClass)UMLPackage.Literals.NAMED_ELEMENT);
        for (NamedElement element : elements) {
            ExternalElementReference reference = AlfFactory.eINSTANCE.createExternalElementReference();
            reference.setElement((EObject)element);
            references.add((Object)reference);
        }
        return references;
    }

    @Override
    public EList<ElementReference> resolveAssociationEnd(ElementReference oppositeEndType, String name) {
        try {
            return (EList)RESOLVE_ASSOCIATION_END_ELEMENT_REFERENCE_STRING__EINVOCATION_DELEGATE.dynamicInvoke((InternalEObject)this, (EList)new BasicEList.UnmodifiableEList(2, new Object[]{oppositeEndType, name}));
        }
        catch (InvocationTargetException ite) {
            throw new WrappedException((Exception)ite);
        }
    }

    @Override
    public int eDerivedOperationID(int baseOperationID, Class<?> baseClass) {
        if (baseClass == MemberDefinition.class) {
            switch (baseOperationID) {
                case 37: {
                    return 94;
                }
                case 39: {
                    return 96;
                }
            }
            return super.eDerivedOperationID(baseOperationID, baseClass);
        }
        if (baseClass == NamespaceDefinition.class) {
            switch (baseOperationID) {
                case 60: {
                    return 94;
                }
                case 63: {
                    return 95;
                }
                case 64: {
                    return 97;
                }
                case 65: {
                    return 101;
                }
                case 84: {
                    return 102;
                }
            }
            return super.eDerivedOperationID(baseOperationID, baseClass);
        }
        if (baseClass == PackageDefinition.class) {
            switch (baseOperationID) {
                case 92: {
                    return 101;
                }
            }
            return super.eDerivedOperationID(baseOperationID, baseClass);
        }
        return super.eDerivedOperationID(baseOperationID, baseClass);
    }

    @Override
    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 93: {
                return this.context();
            }
            case 94: {
                return this.outerScope();
            }
            case 95: {
                return this.modelScope();
            }
            case 96: {
                return this.qualifiedName();
            }
            case 97: {
                return this.resolveInScope((String)arguments.get(0));
            }
            case 98: {
                return this.resolveInRoot((String)arguments.get(0));
            }
            case 99: {
                return this.resolvePathName((String)arguments.get(0));
            }
            case 100: {
                return this.resolveAssociationEnd((ElementReference)arguments.get(0), (String)arguments.get(1));
            }
            case 101: {
                return this.appliedProfiles();
            }
            case 102: {
                return this.stubFor((UnitDefinition)arguments.get(0));
            }
            case 103: {
                return this.ModelNamespace_appliedProfiles();
            }
        }
        return super.eInvoke(operationID, arguments);
    }
}

