/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.stereotype.migration.commands;

import java.util.StringTokenizer;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.common.stereotype.StereotypeLocationEnum;
import org.eclipse.papyrus.uml.diagram.common.stereotype.display.IStereotypeViewProvider;
import org.eclipse.papyrus.uml.diagram.common.stereotype.display.StereotypeViewProvider;
import org.eclipse.papyrus.uml.diagram.common.stereotype.display.helper.StereotypeDisplayUtil;
import org.eclipse.papyrus.uml.diagram.common.stereotype.migration.StereotypeMigrationHelper;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;

public class StereotypePropertiesMigrationCommand
extends AbstractTransactionalCommand {
    protected View mainView;
    private IStereotypeViewProvider provider;
    protected static final StereotypeMigrationHelper migrationHelper = StereotypeMigrationHelper.getInstance();
    protected static final StereotypeDisplayUtil helper = StereotypeDisplayUtil.getInstance();

    public StereotypePropertiesMigrationCommand(String label, View content) {
        super(migrationHelper.getDomain((EObject)content), label, null);
        this.mainView = content;
    }

    protected void migrateStereotypeProperties(View view) {
        this.createProvider(view);
        if (migrationHelper.hasStereotypeEAnnotation(view)) {
            String oldProperties = this.getOldPropertiesToDisplay(view);
            String oldPropertiesLocation = this.getOldLocationToDisplay(view);
            Enum<?> location = this.getLocation(oldPropertiesLocation);
            this.updateStereotypePropertyDisplay(view, oldProperties, location);
        }
    }

    public Enum<?> getLocation(String oldProperties) {
        StereotypeLocationEnum location = StereotypeLocationEnum.IN_BRACE;
        if (oldProperties.equals("Compartment")) {
            location = StereotypeLocationEnum.IN_COMPARTMENT;
        } else if (oldProperties.equals("With brace")) {
            location = StereotypeLocationEnum.IN_BRACE;
        } else if (oldProperties.equals("Comment")) {
            location = StereotypeLocationEnum.IN_COMMENT;
        }
        return location;
    }

    protected void createProvider(View view) {
        this.provider = new StereotypeViewProvider(view);
    }

    protected void updateStereotypePropertyDisplay(View view, String propertyList, Enum<?> location) {
        this.showStereotypePropertyToBeDisplayed(propertyList, view, location);
    }

    private void showStereotypePropertyToBeDisplayed(String propertyList, View view, Enum<?> location) {
        StringTokenizer tokenizer = new StringTokenizer(propertyList, ",");
        while (tokenizer.hasMoreTokens()) {
            String propertyString = tokenizer.nextToken();
            Stereotype stereoytpe = this.getStereotypeFromString(view, propertyString);
            if (stereoytpe == null) continue;
            Property property = this.getPropertyFromString(view, propertyString, stereoytpe);
            this.showStereotypeProperty(view, stereoytpe, property, location);
        }
    }

    private void showStereotypeProperty(View view, Stereotype stereotype, Property property, Enum<?> location) {
        migrationHelper.updateVisibilityAndPersistence(view, (EObject)view, true);
        View compartment = this.provider.getCompartment(stereotype, location);
        migrationHelper.updateVisibilityAndPersistence(compartment, (EObject)view, true);
        View propertyView = this.provider.getProperty(property, stereotype, location);
        migrationHelper.updateVisibilityAndPersistence(propertyView, (EObject)view, true);
    }

    private void hideStereotypePropertyNotDisplayed(String propertyList, View view, Enum<?> location) {
        EList<Stereotype> appliedStereotypesFromView = migrationHelper.getAppliedStereotypesFromView(view);
        if (appliedStereotypesFromView != null) {
            for (Stereotype stereotype : appliedStereotypesFromView) {
                this.hideStereotypeProperties(stereotype, propertyList, location);
            }
        }
    }

    private void hideStereotypeProperties(Stereotype stereotype, String propertyList, Enum<?> location) {
        for (Property property : stereotype.allAttributes()) {
            if (propertyList.indexOf(property.getName()) != -1) continue;
            this.hideStereotypeProperty(property, stereotype, location);
        }
    }

    private void hideStereotypeProperty(Property property, Stereotype stereotype, Enum<?> location) {
        View propertyView;
        View compartment = this.provider.getCompartment(stereotype, location);
        if (compartment != null && (propertyView = this.provider.getProperty(property, stereotype, location)) != null) {
            migrationHelper.updateVisibilityAndPersistence(propertyView, (EObject)this.mainView, false);
        }
    }

    private Property getPropertyFromString(View view, String propertyString, Stereotype stereotype) {
        String propertyName = propertyString.substring(propertyString.indexOf(".") + 1, propertyString.length());
        return migrationHelper.getPropertyFromString(view, stereotype, propertyName);
    }

    private Stereotype getStereotypeFromString(View view, String propertyString) {
        String qualifiedName = propertyString.substring(0, propertyString.indexOf("."));
        return migrationHelper.getStereotypeFromString(view, qualifiedName);
    }

    protected String getOldLocationToDisplay(View view) {
        return migrationHelper.getAppliedStereotypesPropertiesLocalization((EModelElement)view);
    }

    protected String getOldPropertiesToDisplay(View view) {
        return migrationHelper.getAppliedStereotypesPropertiesToDisplay((EModelElement)view);
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        this.migrateStereotypeProperties(this.mainView);
        return CommandResult.newOKCommandResult();
    }
}

