/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.telnet.internal.ui;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteConnectionType;
import org.eclipse.remote.core.exception.RemoteConnectionException;
import org.eclipse.remote.telnet.internal.ui.Activator;
import org.eclipse.remote.telnet.internal.ui.TelnetConnectionWizard;
import org.eclipse.remote.ui.AbstractRemoteUIConnectionService;
import org.eclipse.remote.ui.IRemoteUIConnectionService;
import org.eclipse.remote.ui.IRemoteUIConnectionWizard;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;

public class TelnetConnectionsUI
extends AbstractRemoteUIConnectionService {
    private final IRemoteConnectionType connectionType;

    private TelnetConnectionsUI(IRemoteConnectionType connectionType) {
        this.connectionType = connectionType;
    }

    public IRemoteConnectionType getConnectionType() {
        return this.connectionType;
    }

    public IRemoteUIConnectionWizard getConnectionWizard(Shell shell) {
        return new TelnetConnectionWizard(shell, this.connectionType);
    }

    public void openConnectionWithProgress(Shell shell, IRunnableContext context, final IRemoteConnection connection) {
        try {
            IRunnableWithProgress op = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        connection.open(monitor);
                    }
                    catch (RemoteConnectionException e) {
                        throw new InvocationTargetException(e);
                    }
                    if (monitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                }
            };
            if (context != null) {
                context.run(true, true, op);
            } else {
                new ProgressMonitorDialog(shell).run(true, true, op);
            }
        }
        catch (InterruptedException | InvocationTargetException e) {
            Activator.log(e);
        }
    }

    public ILabelProvider getLabelProvider() {
        return new AbstractRemoteUIConnectionService.DefaultLabelProvider(){

            public Image getImage(Object element) {
                return Activator.getDefault().getImageRegistry().get("org.eclipse.remote.telnet.ui.connectionType");
            }
        };
    }

    /* synthetic */ TelnetConnectionsUI(IRemoteConnectionType iRemoteConnectionType, TelnetConnectionsUI telnetConnectionsUI) {
        this(iRemoteConnectionType);
    }

    public static class Factory
    implements IRemoteConnectionType.Service.Factory {
        public <T extends IRemoteConnectionType.Service> T getService(IRemoteConnectionType connectionType, Class<T> service) {
            if (IRemoteUIConnectionService.class.equals(service)) {
                return (T)((Object)new TelnetConnectionsUI(connectionType, null));
            }
            return null;
        }
    }
}

