/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui.launch;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.tcf.internal.debug.launch.TCFLaunchDelegate;
import org.eclipse.tcf.internal.debug.ui.Activator;
import org.eclipse.tcf.internal.debug.ui.ImageCache;
import org.eclipse.tcf.internal.debug.ui.launch.PathMapRuleDialog;
import org.eclipse.tcf.services.IPathMap;
import org.eclipse.ui.PlatformUI;

public class TCFPathMapTab
extends AbstractLaunchConfigurationTab {
    private CheckboxTableViewer viewer;
    private Button button_add;
    private Button button_edit;
    private Button button_remove;
    private Button button_up;
    private Button button_down;
    private MenuItem item_add;
    private MenuItem item_edit;
    private MenuItem item_remove;
    private MenuItem item_up;
    private MenuItem item_down;
    protected static final int SIZING_TABLE_WIDTH = 500;
    protected static final int SIZING_TABLE_HEIGHT = 300;
    private static final String[] column_ids = new String[]{"", "Source", "Destination", "ContextQuery"};
    private static final String[] column_names = new String[]{"", "Source", "Destination", "Context query"};
    protected static final String PROP_ENABLED = "Enabled";
    protected static final String PROP_GENERATED = "Generated";
    private static final String ATTR_PATH_MAP_V1 = "org.eclipse.tcf.debug.PathMapV1";
    private static final String TAB_ID = "org.eclipse.tcf.launch.pathMapTab";
    private List<IPathMap.PathMapRule> map;
    private Exception init_error;

    public String getName() {
        return "Path Map";
    }

    public Image getImage() {
        return ImageCache.getImage("icons/path");
    }

    public String getId() {
        return TAB_ID;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.createTable(composite);
        this.createCustomControls(composite);
        this.setControl((Control)composite);
    }

    protected void createCustomControls(Composite parent) {
    }

    private void createTable(Composite parent) {
        Font font = parent.getFont();
        Label map_label = new Label(parent, 64);
        map_label.setLayoutData((Object)new GridData(768));
        map_label.setFont(font);
        map_label.setText("File Path Map Rules:");
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setFont(font);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        Table table = new Table(composite, 68386);
        table.setFont(font);
        this.configureTable(table);
        this.viewer = new CheckboxTableViewer(table);
        this.viewer.setContentProvider((IContentProvider)new FileMapContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new FileMapLabelProvider());
        this.viewer.setCheckStateProvider((ICheckStateProvider)new FileCheckStateProvider());
        this.viewer.addCheckStateListener((ICheckStateListener)new FileCheckStateListener());
        this.viewer.setColumnProperties(column_ids);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TCFPathMapTab.this.updateButtons();
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (TCFPathMapTab.this.button_edit.isEnabled()) {
                    TCFPathMapTab.this.onEdit((IStructuredSelection)TCFPathMapTab.this.viewer.getSelection());
                }
            }
        });
        this.configureTableViewer(this.viewer);
        table.pack(true);
        this.createTableButtons(composite);
    }

    protected void configureTableViewer(CheckboxTableViewer viewer) {
    }

    protected void configureTable(Table table) {
        GridData data = new GridData(1810);
        data.widthHint = 500;
        data.heightHint = 300;
        table.setLayoutData((Object)data);
        TableColumn colEnable = new TableColumn(table, 0);
        colEnable.setResizable(false);
        colEnable.setAlignment(0x1000000);
        colEnable.setText(this.getColumnText(0));
        TableColumn colSource = new TableColumn(table, 1);
        colSource.setResizable(true);
        colSource.setAlignment(16384);
        colSource.setText(this.getColumnText(1));
        TableColumn colDest = new TableColumn(table, 2);
        colDest.setResizable(true);
        colDest.setAlignment(16384);
        colDest.setText(this.getColumnText(2));
        TableColumn colQuery = null;
        if (this.showContextQuery()) {
            colQuery = new TableColumn(table, 3);
            colQuery.setResizable(true);
            colQuery.setAlignment(16384);
            colQuery.setText(this.getColumnText(3));
        }
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(30));
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(300));
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(300));
        if (this.showContextQuery()) {
            layout.addColumnData((ColumnLayoutData)new ColumnPixelData(100));
        }
        table.setLayout((Layout)layout);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
    }

    protected boolean showContextQuery() {
        return true;
    }

    protected String getColumnText(int c) {
        if (c < column_names.length && c >= 0) {
            return column_names[c];
        }
        return "";
    }

    private void createTableButtons(Composite parent) {
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setFont(font);
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(272);
        composite.setLayoutData((Object)gd);
        Menu menu = new Menu((Control)this.viewer.getTable());
        SelectionAdapter sel_adapter = null;
        this.button_add = new Button(composite, 8);
        this.button_add.setText(" &Add... ");
        gd = new GridData(256);
        PixelConverter converter = new PixelConverter((Control)this.button_add);
        gd.widthHint = converter.convertHorizontalDLUsToPixels(61);
        this.button_add.setLayoutData((Object)gd);
        sel_adapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TCFPathMapTab.this.onAdd();
            }
        };
        this.button_add.addSelectionListener((SelectionListener)sel_adapter);
        this.item_add = new MenuItem(menu, 8);
        this.item_add.setText("&Add...");
        this.item_add.addSelectionListener((SelectionListener)sel_adapter);
        this.item_add.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ADD"));
        this.button_edit = new Button(composite, 8);
        this.button_edit.setText(" &Edit... ");
        this.button_edit.setLayoutData((Object)new GridData(256));
        sel_adapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TCFPathMapTab.this.onEdit((IStructuredSelection)TCFPathMapTab.this.viewer.getSelection());
            }
        };
        this.button_edit.addSelectionListener((SelectionListener)sel_adapter);
        this.item_edit = new MenuItem(menu, 8);
        this.item_edit.setText("&Edit...");
        this.item_edit.addSelectionListener((SelectionListener)sel_adapter);
        this.button_remove = new Button(composite, 8);
        this.button_remove.setText(" &Remove ");
        this.button_remove.setLayoutData((Object)new GridData(256));
        sel_adapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TCFPathMapTab.this.onRemove((IStructuredSelection)TCFPathMapTab.this.viewer.getSelection());
            }
        };
        this.button_remove.addSelectionListener((SelectionListener)sel_adapter);
        this.item_remove = new MenuItem(menu, 8);
        this.item_remove.setText("&Remove");
        this.item_remove.addSelectionListener((SelectionListener)sel_adapter);
        this.item_remove.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_ETOOL_DELETE"));
        new MenuItem(menu, 2);
        this.button_up = new Button(composite, 8);
        this.button_up.setText(" &Up ");
        this.button_up.setLayoutData((Object)new GridData(256));
        sel_adapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TCFPathMapTab.this.onUp();
            }
        };
        this.button_up.addSelectionListener((SelectionListener)sel_adapter);
        this.item_up = new MenuItem(menu, 8);
        this.item_up.setText("&Up");
        this.item_up.addSelectionListener((SelectionListener)sel_adapter);
        this.button_down = new Button(composite, 8);
        this.button_down.setText(" &Down ");
        this.button_down.setLayoutData((Object)new GridData(256));
        sel_adapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TCFPathMapTab.this.onDown();
            }
        };
        this.button_down.addSelectionListener((SelectionListener)sel_adapter);
        this.item_down = new MenuItem(menu, 8);
        this.item_down.setText("&Down");
        this.item_down.addSelectionListener((SelectionListener)sel_adapter);
        this.viewer.getTable().setMenu(menu);
    }

    private void onAdd() {
        int index = this.viewer.getTable().getSelectionIndex();
        TCFLaunchDelegate.PathMapRule rule = new TCFLaunchDelegate.PathMapRule(new LinkedHashMap());
        PathMapRuleDialog dialog = new PathMapRuleDialog(this.getShell(), null, (IPathMap.PathMapRule)rule, true, this.showContextQuery());
        if (dialog.open() == 0) {
            if (index >= 0) {
                this.map.add(index, (IPathMap.PathMapRule)rule);
            } else {
                this.map.add(0, (IPathMap.PathMapRule)rule);
            }
            this.viewer.refresh(true);
            this.updateLaunchConfigurationDialog();
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)rule), true);
        }
    }

    private void onEdit(IStructuredSelection selection) {
        IPathMap.PathMapRule rule = (IPathMap.PathMapRule)selection.getFirstElement();
        PathMapRuleDialog dialog = new PathMapRuleDialog(this.getShell(), null, rule, true, this.showContextQuery());
        dialog.open();
        this.viewer.refresh(true);
        this.updateLaunchConfigurationDialog();
    }

    private void onRemove(IStructuredSelection selection) {
        for (IPathMap.PathMapRule rule : (IStructuredSelection)this.viewer.getSelection()) {
            this.map.remove(rule);
        }
        this.viewer.refresh(true);
        this.updateLaunchConfigurationDialog();
    }

    private void onUp() {
        int index = this.viewer.getTable().getSelectionIndex();
        IPathMap.PathMapRule rule = this.map.remove(index);
        this.map.add(index - 1, rule);
        this.viewer.refresh(true);
        this.updateLaunchConfigurationDialog();
        this.viewer.setSelection((ISelection)new StructuredSelection((Object)rule), true);
    }

    private void onDown() {
        int index = this.viewer.getTable().getSelectionIndex();
        IPathMap.PathMapRule rule = this.map.remove(index);
        this.map.add(index + 1, rule);
        this.viewer.refresh(true);
        this.updateLaunchConfigurationDialog();
        this.viewer.setSelection((ISelection)new StructuredSelection((Object)rule), true);
    }

    protected final TableViewer getViewer() {
        return this.viewer;
    }

    List<IPathMap.PathMapRule> getPathMap() {
        return Collections.unmodifiableList(this.map);
    }

    public void initializeFrom(ILaunchConfiguration config) {
        this.setErrorMessage(null);
        this.setMessage(null);
        this.map = new ArrayList<IPathMap.PathMapRule>();
        this.initializePathMap(this.map, config);
        this.viewer.setInput((Object)config);
        this.updateLaunchConfigurationDialog();
    }

    protected void initializePathMap(List<IPathMap.PathMapRule> map, ILaunchConfiguration config) {
        Assert.isNotNull(map);
        Assert.isNotNull((Object)config);
        try {
            String s = config.getAttribute("org.eclipse.tcf.debug.PathMap", "");
            String s1 = config.getAttribute(ATTR_PATH_MAP_V1, "");
            ArrayList m = TCFLaunchDelegate.parsePathMapAttribute((String)s);
            ArrayList m1 = TCFLaunchDelegate.parsePathMapAttribute((String)s1);
            for (IPathMap.PathMapRule rule : m1) {
                map.add(rule);
            }
            int i = -1;
            for (IPathMap.PathMapRule rule : m) {
                if (map.contains(rule)) {
                    i = map.indexOf(rule);
                    continue;
                }
                map.add(++i, rule);
            }
        }
        catch (Exception e) {
            this.init_error = e;
            this.setErrorMessage("Cannot read launch configuration: " + e);
            Activator.log(e);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        for (IPathMap.PathMapRule m : this.map) {
            m.getProperties().remove("ID");
        }
        StringBuffer bf = new StringBuffer();
        StringBuffer bf1 = new StringBuffer();
        for (IPathMap.PathMapRule m : this.map) {
            if (m.getProperties().containsKey(PROP_GENERATED) && Boolean.parseBoolean(m.getProperties().get(PROP_GENERATED).toString())) continue;
            boolean enabled = true;
            if (m.getProperties().containsKey(PROP_ENABLED)) {
                enabled = Boolean.parseBoolean(m.getProperties().get(PROP_ENABLED).toString());
            }
            if (enabled) {
                m.getProperties().remove(PROP_ENABLED);
                bf.append(m.toString());
            }
            bf1.append(m.toString());
        }
        if (bf.length() == 0) {
            config.removeAttribute("org.eclipse.tcf.debug.PathMap");
        } else {
            config.setAttribute("org.eclipse.tcf.debug.PathMap", bf.toString());
        }
        if (bf1.length() == 0) {
            config.removeAttribute(ATTR_PATH_MAP_V1);
        } else {
            config.setAttribute(ATTR_PATH_MAP_V1, bf1.toString());
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        config.removeAttribute("org.eclipse.tcf.debug.PathMap");
        config.removeAttribute(ATTR_PATH_MAP_V1);
    }

    protected void updateLaunchConfigurationDialog() {
        super.updateLaunchConfigurationDialog();
        this.updateButtons();
    }

    protected void updateButtons() {
        boolean singleSelection = ((IStructuredSelection)this.viewer.getSelection()).size() == 1;
        int index = this.viewer.getTable().getSelectionIndex();
        int count = this.viewer.getTable().getItemCount();
        IPathMap.PathMapRule selected = (IPathMap.PathMapRule)((IStructuredSelection)this.viewer.getSelection()).getFirstElement();
        boolean isGenerated = selected != null && selected.getProperties().containsKey(PROP_GENERATED) ? Boolean.parseBoolean(selected.getProperties().get(PROP_GENERATED).toString()) : false;
        this.button_remove.setEnabled(!this.viewer.getSelection().isEmpty() && !isGenerated);
        this.button_edit.setEnabled(singleSelection && !isGenerated);
        this.button_up.setEnabled(singleSelection && index > 0 && !isGenerated);
        this.button_down.setEnabled(singleSelection && index < count - 1 && !isGenerated);
        this.item_remove.setEnabled(!this.viewer.getSelection().isEmpty() && !isGenerated);
        this.item_edit.setEnabled(singleSelection && !isGenerated);
        this.item_up.setEnabled(singleSelection && index > 0 && !isGenerated);
        this.item_down.setEnabled(singleSelection && index < count - 1 && !isGenerated);
    }

    public boolean isValid(ILaunchConfiguration config) {
        this.setMessage(null);
        if (this.init_error != null) {
            this.setErrorMessage("Cannot read launch configuration: " + this.init_error);
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    private class FileCheckStateListener
    implements ICheckStateListener {
        private FileCheckStateListener() {
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            IPathMap.PathMapRule rule = (IPathMap.PathMapRule)event.getElement();
            if (rule.getProperties().containsKey(TCFPathMapTab.PROP_GENERATED) && Boolean.parseBoolean(rule.getProperties().get(TCFPathMapTab.PROP_GENERATED).toString())) {
                TCFPathMapTab.this.viewer.refresh();
                return;
            }
            if (event.getChecked()) {
                rule.getProperties().remove(TCFPathMapTab.PROP_ENABLED);
            } else {
                rule.getProperties().put(TCFPathMapTab.PROP_ENABLED, Boolean.FALSE);
            }
            TCFPathMapTab.this.viewer.refresh();
            TCFPathMapTab.this.updateLaunchConfigurationDialog();
        }
    }

    private class FileCheckStateProvider
    implements ICheckStateProvider {
        private FileCheckStateProvider() {
        }

        public boolean isChecked(Object element) {
            IPathMap.PathMapRule e = (IPathMap.PathMapRule)element;
            if (e.getProperties().containsKey(TCFPathMapTab.PROP_ENABLED)) {
                return Boolean.parseBoolean(e.getProperties().get(TCFPathMapTab.PROP_ENABLED).toString());
            }
            return true;
        }

        public boolean isGrayed(Object element) {
            return false;
        }
    }

    private class FileMapContentProvider
    implements IStructuredContentProvider {
        private FileMapContentProvider() {
        }

        public Object[] getElements(Object input) {
            return TCFPathMapTab.this.map.toArray(new IPathMap.PathMapRule[TCFPathMapTab.this.map.size()]);
        }

        public void inputChanged(Viewer viewer, Object old_input, Object new_input) {
        }

        public void dispose() {
        }
    }

    private class FileMapLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    IColorProvider {
        private FileMapLabelProvider() {
        }

        public Image getColumnImage(Object element, int column) {
            return null;
        }

        public String getColumnText(Object element, int column) {
            IPathMap.PathMapRule e = (IPathMap.PathMapRule)element;
            Object o = e.getProperties().get(column_ids[column]);
            if (o == null) {
                return "";
            }
            return o.toString();
        }

        public Color getForeground(Object element) {
            IPathMap.PathMapRule rule;
            if (element instanceof IPathMap.PathMapRule && (rule = (IPathMap.PathMapRule)element).getProperties().containsKey(TCFPathMapTab.PROP_GENERATED) && Boolean.parseBoolean(rule.getProperties().get(TCFPathMapTab.PROP_GENERATED).toString())) {
                return PlatformUI.getWorkbench().getDisplay().getSystemColor(15);
            }
            return null;
        }

        public Color getBackground(Object element) {
            return null;
        }
    }
}

