/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui.preferences;

import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class DecoratingIntegerFieldEditor
extends IntegerFieldEditor {
    private ControlDecoration fDecoration;

    protected DecoratingIntegerFieldEditor() {
    }

    public DecoratingIntegerFieldEditor(String name, String labelText, Composite parent) {
        super(name, labelText, parent);
    }

    public DecoratingIntegerFieldEditor(String name, String labelText, Composite parent, int textLimit) {
        super(name, labelText, parent, textLimit);
    }

    public Text getTextControl(Composite parent) {
        Text control = super.getTextControl(parent);
        if (this.fDecoration == null) {
            this.fDecoration = new ControlDecoration((Control)control, 16512);
            FieldDecoration errorDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
            this.fDecoration.setImage(errorDecoration.getImage());
            this.fDecoration.setDescriptionText(this.getErrorMessage());
            control.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusGained(FocusEvent e) {
                    DecoratingIntegerFieldEditor.this.refreshValidState();
                }
            });
        }
        return control;
    }

    protected void showErrorMessage(String msg) {
        super.showErrorMessage(msg);
        if (this.fDecoration != null) {
            this.fDecoration.setDescriptionText(msg);
            this.fDecoration.show();
        }
    }

    protected void clearErrorMessage() {
        super.clearErrorMessage();
        if (this.fDecoration != null) {
            this.fDecoration.hide();
        }
    }
}

