/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.terminal.provisional.api;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.widgets.Control;
import org.eclipse.tm.internal.terminal.provisional.api.ISettingsPage;

public abstract class AbstractSettingsPage
implements ISettingsPage,
IMessageProvider {
    private String message = null;
    private int messageType = 0;
    private final ListenerList<ISettingsPage.Listener> listeners = new ListenerList();
    private boolean hasDecoration = false;

    @Override
    public void addListener(ISettingsPage.Listener listener) {
        Assert.isNotNull((Object)listener);
        this.listeners.add((Object)listener);
    }

    @Override
    public void removeListener(ISettingsPage.Listener listener) {
        Assert.isNotNull((Object)listener);
        this.listeners.remove((Object)listener);
    }

    public void fireListeners(Control control) {
        Object[] list = this.listeners.getListeners();
        int i = 0;
        while (i < list.length) {
            Object l = list[i];
            if (l instanceof ISettingsPage.Listener) {
                ((ISettingsPage.Listener)l).onSettingsPageChanged(control);
            }
            ++i;
        }
    }

    public final String getMessage() {
        return this.message;
    }

    public final int getMessageType() {
        return this.messageType;
    }

    public final void setMessage(String message, int messageType) {
        this.message = message;
        this.messageType = messageType;
    }

    public final void setHasControlDecoration(boolean value) {
        this.hasDecoration = value;
    }

    protected final boolean hasControlDecoration() {
        return this.hasDecoration;
    }

    protected final ControlDecoration createControlDecoration(Control control) {
        Assert.isNotNull((Object)control);
        if (!this.hasDecoration) {
            return null;
        }
        ControlDecoration controlDecoration = new ControlDecoration(control, this.getControlDecorationPosition());
        controlDecoration.setShowOnlyOnFocus(false);
        control.setData("controlDecoration", (Object)controlDecoration);
        return controlDecoration;
    }

    protected int getControlDecorationPosition() {
        return 16512;
    }

    protected final void updateControlDecoration(Control control, String message, int messageType) {
        Assert.isNotNull((Object)control);
        ControlDecoration controlDecoration = (ControlDecoration)control.getData("controlDecoration");
        if (controlDecoration != null) {
            controlDecoration.setDescriptionText(message);
            FieldDecorationRegistry registry = FieldDecorationRegistry.getDefault();
            String decorationId = "DEC_INFORMATION";
            if (messageType == 3) {
                decorationId = "DEC_ERROR";
            } else if (messageType == 2) {
                decorationId = "DEC_WARNING";
            }
            FieldDecoration fieldDeco = registry.getFieldDecoration(decorationId);
            if (fieldDeco != null) {
                controlDecoration.setImage(fieldDeco.getImage());
            }
            if (message == null || messageType == 0) {
                controlDecoration.hide();
            } else {
                controlDecoration.show();
            }
        }
    }
}

