/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.util;

import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.util.UriExtensions;

@ImplementedBy(value=JavaIoFileSystemScanner.class)
public interface IFileSystemScanner {
    public void scan(URI var1, IAcceptor<URI> var2);

    public static class JavaIoFileSystemScanner
    implements IFileSystemScanner {
        @Inject
        private UriExtensions uriExtensions;

        @Override
        public void scan(URI root, IAcceptor<URI> acceptor) {
            File file = new File(root.toFileString());
            this.scanRec(file, acceptor);
        }

        public void scanRec(File file, IAcceptor<URI> acceptor) {
            File[] files;
            Path path = Paths.get(file.getAbsoluteFile().toURI());
            URI uri = this.uriExtensions.toEmfUri(path.toUri());
            acceptor.accept(uri);
            if (file.isDirectory() && (files = file.listFiles()) != null) {
                for (File f : files) {
                    this.scanRec(f, acceptor);
                }
            }
        }
    }
}

