/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal.extension;

import com.google.common.collect.Sets;
import com.google.common.graph.ElementOrder;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.Graphs;
import com.google.common.graph.MutableGraph;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.buildship.core.InitializationContext;
import org.eclipse.buildship.core.ProjectConfigurator;
import org.eclipse.buildship.core.ProjectContext;
import org.eclipse.buildship.core.internal.CorePlugin;
import org.eclipse.buildship.core.internal.CoreTraceScopes;
import org.eclipse.buildship.core.internal.GradlePluginsRuntimeException;
import org.eclipse.buildship.core.internal.Logger;
import org.eclipse.buildship.core.internal.extension.ProjectConfiguratorContribution;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public final class InternalProjectConfigurator
implements ProjectConfigurator,
Comparable<InternalProjectConfigurator> {
    private final ProjectConfigurator configurator;
    private final ProjectConfiguratorContribution contribution;
    private static final Logger LOGGER = CorePlugin.logger();

    private InternalProjectConfigurator(ProjectConfiguratorContribution contribution) {
        this.configurator = InternalProjectConfigurator.createConfigurator(contribution);
        this.contribution = contribution;
    }

    private static ProjectConfigurator createConfigurator(ProjectConfiguratorContribution contribution) {
        try {
            return contribution.createConfigurator();
        }
        catch (CoreException e) {
            throw new GradlePluginsRuntimeException(e);
        }
    }

    @Override
    public void init(InitializationContext context, IProgressMonitor monitor) {
        this.configurator.init(context, monitor);
    }

    @Override
    public void configure(ProjectContext context, IProgressMonitor monitor) {
        this.configurator.configure(context, monitor);
    }

    @Override
    public void unconfigure(ProjectContext context, IProgressMonitor monitor) {
        this.configurator.unconfigure(context, monitor);
    }

    public String getContributorPluginId() {
        return this.contribution.getContributorPluginId();
    }

    public String getId() {
        return this.contribution.getId();
    }

    public static List<InternalProjectConfigurator> from(List<ProjectConfiguratorContribution> configurators) {
        if (LOGGER.isScopeEnabled(CoreTraceScopes.PROJECT_CONFIGURATORS)) {
            LOGGER.trace(CoreTraceScopes.PROJECT_CONFIGURATORS, "Contributed configurators: " + configurators.stream().map(Objects::toString).collect(Collectors.joining(", ")));
        }
        configurators = new ArrayList<ProjectConfiguratorContribution>(configurators);
        InternalProjectConfigurator.filterInvalidConfigurators(configurators);
        InternalProjectConfigurator.filterDuplicateIds(configurators);
        InternalProjectConfigurator.filterInvalidDependencies(configurators);
        InternalProjectConfigurator.filterCylicDependencies(configurators);
        return configurators.stream().map(c -> new InternalProjectConfigurator((ProjectConfiguratorContribution)c)).collect(Collectors.toList());
    }

    private static void filterInvalidConfigurators(List<ProjectConfiguratorContribution> configurators) {
        Iterator<ProjectConfiguratorContribution> it = configurators.iterator();
        while (it.hasNext()) {
            ProjectConfiguratorContribution configurator = it.next();
            if (configurator.getId() == null) {
                LOGGER.trace(CoreTraceScopes.PROJECT_CONFIGURATORS, configurator.getId() + " was removed because it had no ID defined");
                it.remove();
                continue;
            }
            try {
                configurator.createConfigurator();
            }
            catch (Exception e) {
                LOGGER.trace(CoreTraceScopes.PROJECT_CONFIGURATORS, configurator.getId() + " was removed because configurator instance cannot be created", e);
                it.remove();
            }
        }
    }

    private static void filterDuplicateIds(List<ProjectConfiguratorContribution> configurators) {
        HashSet ids = Sets.newHashSet();
        Iterator<ProjectConfiguratorContribution> it = configurators.iterator();
        while (it.hasNext()) {
            ProjectConfiguratorContribution configurator = it.next();
            String id = configurator.getId();
            if (ids.contains(id)) {
                LOGGER.trace(CoreTraceScopes.PROJECT_CONFIGURATORS, configurator.getId() + " was removed because another configurator already exists with same ID");
                it.remove();
                continue;
            }
            ids.add(id);
        }
    }

    private static void filterInvalidDependencies(List<ProjectConfiguratorContribution> configurators) {
        Map<String, ProjectConfiguratorContribution> idToConfigurator = configurators.stream().collect(Collectors.toMap(ProjectConfiguratorContribution::getId, Function.identity()));
        for (ProjectConfiguratorContribution configurator : configurators) {
            InternalProjectConfigurator.filterInvalidDependencies(idToConfigurator, configurator.getId(), configurator.getRunsBefore());
            InternalProjectConfigurator.filterInvalidDependencies(idToConfigurator, configurator.getId(), configurator.getRunsAfter());
        }
    }

    private static void filterInvalidDependencies(Map<String, ProjectConfiguratorContribution> idToConfigurator, String currentId, List<String> dependencyIds) {
        Iterator<String> it = dependencyIds.iterator();
        while (it.hasNext()) {
            String id = it.next();
            if (id.equals(currentId)) {
                LOGGER.trace(CoreTraceScopes.PROJECT_CONFIGURATORS, "Configurator " + currentId + " self-dependency removed");
                it.remove();
                continue;
            }
            if (idToConfigurator.get(id) != null) continue;
            it.remove();
            LOGGER.trace(CoreTraceScopes.PROJECT_CONFIGURATORS, "Configurator dependency (" + currentId + " -> " + id + ") removed because dependency does not exist");
        }
    }

    private static void filterCylicDependencies(List<ProjectConfiguratorContribution> configurators) {
        Map<String, ProjectConfiguratorContribution> idToConfigurator = configurators.stream().collect(Collectors.toMap(ProjectConfiguratorContribution::getId, Function.identity()));
        MutableGraph dependencyGraph = GraphBuilder.directed().nodeOrder(ElementOrder.insertion()).build();
        configurators.forEach(c -> dependencyGraph.addNode(c));
        for (ProjectConfiguratorContribution configurator : configurators) {
            InternalProjectConfigurator.filterCylicDependencies(configurator, configurator.getRunsBefore(), idToConfigurator, (MutableGraph<ProjectConfiguratorContribution>)dependencyGraph, false);
            InternalProjectConfigurator.filterCylicDependencies(configurator, configurator.getRunsAfter(), idToConfigurator, (MutableGraph<ProjectConfiguratorContribution>)dependencyGraph, true);
        }
    }

    private static void filterCylicDependencies(ProjectConfiguratorContribution configurator, List<String> dependencyIds, Map<String, ProjectConfiguratorContribution> idToConfigurator, MutableGraph<ProjectConfiguratorContribution> dependencyGraph, boolean reverseDirection) {
        Iterator<String> it = dependencyIds.iterator();
        while (it.hasNext()) {
            ProjectConfiguratorContribution otherConfigurator = idToConfigurator.get(it.next());
            ProjectConfiguratorContribution source = reverseDirection ? otherConfigurator : configurator;
            ProjectConfiguratorContribution target = reverseDirection ? configurator : otherConfigurator;
            dependencyGraph.putEdge((Object)source, (Object)target);
            if (!Graphs.hasCycle(dependencyGraph)) continue;
            LOGGER.trace(CoreTraceScopes.PROJECT_CONFIGURATORS, "Configurator dependency (" + source.getId() + " -> " + target.getId() + ") removed because it introduces dependency cycle");
            dependencyGraph.removeEdge((Object)source, (Object)target);
            it.remove();
        }
    }

    @Override
    public int compareTo(InternalProjectConfigurator that) {
        if (this.runsBefore(that) || that.runsAfter(this)) {
            return -1;
        }
        if (this.runsAfter(that) || that.runsBefore(this)) {
            return 1;
        }
        return 0;
    }

    private boolean runsBefore(InternalProjectConfigurator that) {
        return this.contribution.getRunsBefore().contains(that.getId());
    }

    private boolean runsAfter(InternalProjectConfigurator that) {
        return this.contribution.getRunsAfter().contains(that.getId());
    }
}

